// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/2d/hkgVdb2dWidget.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbStatsHandler.h>
#include <VisualDebugger/VdbServices/System/Connection/hkVdbConnection.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/Utils/hkgVdbTextBoxDrawer.h>

class hkgFont;
struct hkVdbFrame;
struct hkVdbCmd;

//////////////////////////////////////////////////////////////////////////
/// A widget which draws some status information to the screen.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbStatusWidget : public hkgVdb2dWidget
{
public:
    HK_DECLARE_CLASS( hkgVdbStatusWidget, New, ReflectIdentity );
    hkgVdbStatusWidget();

    //
    // hkgVdb2dWidget
    //

    virtual hkResult initialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult update( const hkgViewport& viewport, const hkgInputManager& input ) HK_OVERRIDE;
    virtual void render( hkgDisplayContext& context ) const HK_OVERRIDE;
    virtual hkgVdbBounds getBounds() const HK_OVERRIDE { return m_bounds; }


    //
    // Control
    //

    /// Access the current options.
    hkgVdbTextBoxDrawerOptions& accessOptions() { return m_options; }

    /// Get the default font used to draw text.
    hkgFont& getDefaultFont() { return *m_defaultFont; }

    //
    // Internal use
    //

    void onFrameStatsUpdatedSignal( const hkVdbStatsHandler::FrameStats& frameStats );
    void onStepCompletedSignal( const hkVdbFrame& frame, const hkVdbCmd& cmd );
    void onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection );
    void onDisconnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection );

protected:

    virtual hkResult enable() HK_OVERRIDE;
    virtual hkResult disable() HK_OVERRIDE;

    void reset();

    hkgWindow* m_window;
    hkRefPtr<hkVdbClient> m_client;
    hkRefPtr<hkgFont> m_defaultFont;
    mutable hkgVdbTextBoxDrawerOptions m_options;
    mutable hkgVdbBounds m_bounds;

    mutable hkStopwatch m_continuousStopwatch;
    mutable hkStopwatch m_spfStopwatch;
    mutable hkWindowedAverage m_spfCalc;
    hkReal m_serverStepFps;
    hkReal m_serverVdbStepFps;
    hkUint64 m_serverFrames;
    hkUint32 m_serverFrameBytes;
    hkStringPtr m_serverInfo;
    hkStringPtr m_clientInfo;
    hkStringPtr m_cameraInfo;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
