// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamAnalyzer.h>

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/2d/hkgVdb2dWidget.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbStatsHandler.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/Utils/hkgVdbTextBoxDrawer.h>

class hkgFont;

//////////////////////////////////////////////////////////////////////////
/// A widget which draws stats for the current frame as navigable text.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbStatTextWidget : public hkgVdb2dWidget
{
public:
    HK_DECLARE_CLASS( hkgVdbStatTextWidget, New, ReflectIdentity );
    hkgVdbStatTextWidget();
    ~hkgVdbStatTextWidget();

    //
    // hkgVdb2dWidget
    //

    virtual hkResult initialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult update( const hkgViewport& viewport, const hkgInputManager& input ) HK_OVERRIDE;
    virtual void render( hkgDisplayContext& context ) const HK_OVERRIDE;
    virtual void getToolTip( hkStringBuf& toolTipOut, bool verbose ) const HK_OVERRIDE;
    virtual hkgVdbInputTypes getSupportedInputs() const HK_OVERRIDE { return hkgVdbInputTypes::ALL; }
    virtual hkgVdbBounds getBounds() const HK_OVERRIDE { return m_bounds; }

    //
    // Control
    //

    /// Expand the selected timer node.
    hkBool32 expandNode();

    /// Collapse the selected timer node.
    hkBool32 collapseNode();

    /// Select the selected timer node's previous sibling.
    hkBool32 selectPreviousNode();

    /// Select the selected timer node's next sibling.
    hkBool32 selectNextNode();

    /// Get the selected timer node.
    HK_INLINE const hkMonitorStreamAnalyzer::Node* getSelectedNode() const { return m_activeNode; }

    /// Append the current stat text to the buffer.
    void appendStatText( hkStringBuf& statTextOut ) const;

    /// Copy the current stat text to windows clipboard (if on windows).
    hkResult copyStatTextToClipboard() const;

    /// Access the current options.
    hkgVdbTextBoxDrawerOptions& accessOptions() { return m_options; }

    /// Get the default font used to draw text.
    hkgFont& getDefaultFont() { return *m_defaultFont; }

    //
    // Internal use
    //

    void onConnectedSignal( hkVdbConnectionUse::Enum use, hkVdbConnection& connection );
    void onPerfStatsReceivedSignal( const hkVdbStatsHandler::PerfStats& perfStats, hkVdbSignalResult& result );

protected:

    virtual hkResult enable() HK_OVERRIDE;
    virtual hkResult disable() HK_OVERRIDE;

    void resetStats();
    void writeStatText( hkArray<char>& bufOut ) const;

    hkRefPtr<hkVdbClient> m_client;
    hkRefPtr<hkgFont> m_defaultFont;
    mutable hkgVdbTextBoxDrawerOptions m_options;
    mutable hkgVdbBounds m_bounds;

    mutable hkMonitorStreamAnalyzer::Tree m_statsTree;
    hkPointerMap<char*, char*> m_statsLocalStrings;
    mutable hkMonitorStreamAnalyzer::Node* m_activeNode;
    hkMonitorStreamAnalyzer::Node* m_activeNodeToRestore;
    hkArray<hkMonitorStreamAnalyzer::Node*> m_rootNodesToRestore;
    int m_numThreads;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
