// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/Hash/hkHashSet.h>
#include <Common/Base/Types/Geometry/Rect/hkRect.h>

#include <Graphics/Common/Input/Mouse/hkgMouseDefines.h>
#include <Graphics/Common/Math/hkgOrthoTransform2D.h>

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/2d/hkgVdb2dWidget.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbStatsHandler.h>

class hkgTexture;
class hkgFont;
class hkgVdbStatBarGraph;
class hkgVdbNode2d;
class hkgVdbScene2d;
class hkgVdbStatBarGraphNode2d;

//////////////////////////////////////////////////////////////////////////
/// Options for the hkgVdbStatBarGraphWidget.
/// Note: Not all settings are currently respected/supported, including some dimension settings.
//////////////////////////////////////////////////////////////////////////
struct HK_EXPORT_VDB hkgVdbStatBarGraphWidgetOptions : public hkgVdbDimensions
{
    HK_DECLARE_CLASS( hkgVdbStatBarGraphWidgetOptions, New );

    hkgVdbStatBarGraphWidgetOptions() :
        m_threadTitleColumnColor( hkColor::rgbFromChars( 0xF0, 0xF0, 0xF0, 0x3F ) ),
        m_textColor( hkColor::WHITE ),
        m_evenMsColor( hkColor::rgbFromChars( 0x60, 0x60, 0x60, 0xAA ) ),
        m_oddMsColor( hkColor::rgbFromChars( 0x0, 0x0, 0x0, 0xAA ) ),
        m_selectionColor( hkColor::rgbFromFloats( 0.8, 0.0, 0.3, 0.5 ) ),
        m_zoomStartX( 0.0f ),
        m_zoomEndX( 1.0f ),
        m_threadTitleMargin( 10.0f, 10.0f ),
        m_zoomSearchResults( false ),
        m_autoZoomRate( 0 )
    {}

    /// Text color.
    hkColor::Argb m_textColor;

    /// Color for thread title column.
    hkColor::Argb m_threadTitleColumnColor;

    /// Color for even MS delimiter columns.
    hkColor::Argb m_evenMsColor;

    /// Color for odd MS delimiter columns.
    hkColor::Argb m_oddMsColor;

    /// Selection bar color.
    hkColor::Argb m_selectionColor;

    /// Start of zoom in X.
    hkFloat32 m_zoomStartX;

    /// End of zoom in X.
    hkFloat32 m_zoomEndX;

    /// Margins around the title for threads (equally applied to both sides).
    hkgVdbPointF m_threadTitleMargin;

    /// Should search results be auto-zoomed.
    // NOT YET USED
    hkBool32 m_zoomSearchResults;

    /// If a positive value the graph will zoom towards including all timers at a rate
    /// determined by this value.  This auto-zoom behavior does not occur when
    /// the user has explicitly zoomed in on an area.
    // NOT YET USED
    hkFloat32 m_autoZoomRate;

    /// Set the current search string to prune results.
    void setSearchString( const char* searchString ) { m_searchString = searchString; }

    /// Get the current search string to prune results.
    const char* getSearchString() const { return m_searchString; }

    /// Hide timers with the specified name.
    hkBool32 hideTimer( const char* timerName ) { return m_hiddenTimers.insert( timerName ); }

    /// Unhide timers with the specified name.
    hkBool32 unhideTimer( const char* timerName ) { return ( m_hiddenTimers.remove( timerName ).isSuccess() ); }

    /// Get all currently hidden timers.
    int getHiddenTimers( hkArray<const char*>& hiddenTimersOut ) const;

protected:

    hkStringPtr m_searchString;
    hkHashSet<hkStringPtr> m_hiddenTimers;
};

//////////////////////////////////////////////////////////////////////////
/// A widget which draws stats as a series of bars per thread
/// for the current frame. Bars can be collapsed and expanded to show
/// timer hierarchies. Zooming is also supported along the X.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbStatBarGraphWidget : public hkgVdb2dWidget
{
public:
    HK_DECLARE_CLASS( hkgVdbStatBarGraphWidget, New, ReflectIdentity );
    hkgVdbStatBarGraphWidget();
    virtual ~hkgVdbStatBarGraphWidget();

    //
    // 2d Widget interface
    //

    virtual hkResult initialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult update( const hkgViewport& viewport, const hkgInputManager& input ) HK_OVERRIDE;
    virtual void render( hkgDisplayContext& context ) const HK_OVERRIDE;
    virtual hkgVdbBounds getBounds() const HK_OVERRIDE { return m_bounds; }
    virtual void getToolTip( hkStringBuf& toolTipOut, bool verbose ) const HK_OVERRIDE;
    virtual hkgVdbInputTypes getSupportedInputs() const HK_OVERRIDE { return hkgVdbInputTypes::MOUSE; }
    virtual hkgVdbInputCapabilities getInputCapabilities() const HK_OVERRIDE { return hkgVdbInputCapabilities::MOUSE_WRAPPING; }


    //
    // Control
    //

    /// Access the current options.
    hkgVdbStatBarGraphWidgetOptions& accessOptions() { return m_options; }

    //
    // Internal use
    //

    void onPerfStatsReceivedSignal( const hkVdbStatsHandler::PerfStats& perfStats, hkVdbSignalResult& result );

protected:

    virtual hkResult enable() HK_OVERRIDE;
    virtual hkResult disable() HK_OVERRIDE;

    void updateScene( const hkRectF& bounds );

    hkRefPtr<hkVdbClient> m_client;
    hkRefPtr<hkgFont> m_defaultFont;
    hkgVdbStatBarGraphWidgetOptions m_options;
    mutable hkgVdbBounds m_bounds;

    
    float m_dpiScaling;

    // Buffer of timer data
    hkgVdbDataBuffer<hkArray<hkMonitorStreamParser::Tree*>> m_timerData;

    hkgOrthoTransform2d m_savedTransform;

    // Contains per-thread timer quads extracted from monitor streams
    hkRefPtr<hkgVdbStatBarGraph> m_barGraph;

    // The container object for the bar graph widget scene
    hkRefPtr<hkgVdbScene2d> m_barGraphScene;

    // Convenient aliases for nodes in the bar graph scene that can be manipulated with user input
    hkRefPtr<hkgVdbNode2d> m_rootCanvasNode;
    hkRefPtr<hkgVdbNode2d> m_timelineContainerNode;
    hkRefPtr<hkgVdbNode2d> m_timelineCanvasNode;
    hkArray<hkRefPtr<hkgVdbNode2d>> m_threadNodes;
    hkArray<hkRefPtr<hkgVdbNode2d>> m_threadLabelBackgrounds;
    hkArray<hkRefPtr<hkgVdbNode2d>> m_threadLabels;
    hkRefPtr<hkgVdbStatBarGraphNode2d> m_barGraphNode;
    hkRefPtr<hkgVdbNode2d> m_selectionBoxNode;

    // Mouse input management
    HKG_MOUSE_BUTTON m_mouseDragState;
    hkVector2 m_mouseDragStart;
    hkVector2 m_mouseCurrentPosition;
    hkVector2 m_mousePreviousPosition;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
