// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>
#include <Graphics/Common/Math/hkgOrthoTransform2D.h>

#include <Common/Base/Types/Geometry/Rect/hkRect.h>

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/Utils/hkgVdbStatBarGraph.h>

class hkgVdbNode2d;
class hkgFont;

//////////////////////////////////////////////////////////////////////////
/// Base class for representing a scene of transformable 2d nodes.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbScene2d : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(hkgVdbScene2d, ReflectIdentity);
    hkgVdbScene2d(const hkRectF& inBounds);

    hkgVdbNode2d* getRoot() { return m_root; }
    const hkRectF& getBounds() const { return m_bounds; }
    void setBounds(const hkRectF& inBounds) { m_bounds = inBounds; }

    virtual void render(hkgDisplayContext& context);

protected:
    hkRectF m_bounds;
    hkRefPtr<hkgVdbNode2d> m_root;
};

//////////////////////////////////////////////////////////////////////////
/// Base class for representing transformable 2d nodes in a scene.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_COMMON hkgVdbNode2d : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(hkgVdbNode2d, ReflectIdentity);
    hkgVdbNode2d(const char* inName);

    hkgVdbNode2d* getParent() { return m_parent; }
    void setParent(hkgVdbNode2d* value) { m_parent = value; }
    const hkgOrthoTransform2d& getLocalTransform() const { return m_localTransform; }
    void setLocalTransform(const hkgOrthoTransform2d& value);
    void setLocalTranslation(hkReal x, hkReal y);
    void setLocalScale(hkReal xScale, hkReal yScale);
    const hkgOrthoTransform2d& getGlobalTransform() const;
    const hkColor::Argb getColor() const { return m_color; }
    void setColor(hkColor::Argb value) { m_color = value; }
    const hkVector2& getDimensions() const { return m_dimensions; }
    void setDimensions(hkReal x, hkReal y) { m_dimensions.set(x, y); }
    void getLocalBounds(hkRectF& result) const;
    void getGlobalBounds(hkRectF& result) const;
    const hkArray<hkRefPtr<hkgVdbNode2d>>& getChildren() const { return m_children; }
    void attachChild(hkgVdbNode2d* child);
    void detachChild(hkgVdbNode2d* child);

    virtual void render(hkgDisplayContext& context, const hkRectF& parentBounds);

protected:
    void markGlobalTransformDirty();

    virtual void renderInternal(hkgDisplayContext& context, const hkRectF& rectangle);
    void renderSolidRectangle(hkgDisplayContext& context, const hkRectF& rectangle, hkColor::Argb color, float depth);

protected:
    hkgVdbNode2d* m_parent;
    hkArray<hkRefPtr<hkgVdbNode2d>> m_children;

    hkgOrthoTransform2d m_localTransform;
    mutable hkgOrthoTransform2d m_globalTransform;
    mutable bool m_globalTransformDirty;

    hkVector2 m_dimensions;
    hkColor::Argb m_color;
    hkStringPtr m_name;
};

//////////////////////////////////////////////////////////////////////////
/// Transformable text 2d node for scene.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_COMMON hkgVdbTextNode2d : public hkgVdbNode2d
{
public:
    hkgVdbTextNode2d(const char* inText, hkgFont* inFont);

protected:
    virtual void renderInternal(hkgDisplayContext& context, const hkRectF& rectangle) HK_OVERRIDE;

protected:
    hkRefPtr<hkgFont> m_font;
};

//////////////////////////////////////////////////////////////////////////
/// Transformable bar graph 2d node for scene.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_COMMON hkgVdbStatBarGraphNode2d : public hkgVdbNode2d
{
public:
    hkgVdbStatBarGraphNode2d(hkgVdbStatBarGraph* barGraph)
        : hkgVdbNode2d("BarGraph")
    {
        m_barGraph = barGraph;
    }

protected:
    virtual void renderInternal(hkgDisplayContext& context, const hkRectF& rectangle) HK_OVERRIDE;

protected:
    hkRefPtr<hkgVdbStatBarGraph> m_barGraph;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
