// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/3d/hkgVdb3dWidget.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/Utils/hkgVdbAxisDrawer.h>

//////////////////////////////////////////////////////////////////////////
/// Options for the hkgVdbOrientationWidget.
//////////////////////////////////////////////////////////////////////////
struct HK_EXPORT_VDB hkgVdbOrientationWidgetOptions : public hkgVdbAxisDrawerOptions
{
    HK_DECLARE_CLASS( hkgVdbOrientationWidgetOptions, New );

    hkgVdbOrientationWidgetOptions() :
        m_xOffset( 0 ),
        m_yOffset( 0 )
    {}

    /// An additional x offset (in addition to normal offsetting) to draw the
    /// orientation widget.
    hkUint32 m_xOffset;

    /// An additional y offset (in addition to normal offsetting) to draw the
    /// orientation widget.
    hkUint32 m_yOffset;
};

//////////////////////////////////////////////////////////////////////////
/// A widget which draws a camera orientation axis in the lower left corner
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdbOrientationWidget : public hkgVdb3dWidget
{
public:
    HK_DECLARE_CLASS( hkgVdbOrientationWidget, New, ReflectIdentity );

    //
    // 3d Widget interface
    //

    virtual hkResult initialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual void render( hkgDisplayContext& context ) const HK_OVERRIDE;
    virtual hkgVdbBounds getBounds() const { return m_bounds; } 

    //
    // Control
    //

    /// Access the current options.
    hkgVdbOrientationWidgetOptions& accessOptions() { return m_options; }

protected:

    void updateBounds( hkgDisplayContext& context ) const;

    hkgVdbOrientationWidgetOptions m_options;
    mutable hkgVdbBounds m_bounds;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
