// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPlugin.h>
#include <VisualDebugger/VdbDisplay/Hkg/hkgVdbPluginApi.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/2d/hkgVdbOrientationWidget.h>

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>
#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Common/Camera/hkgCamera.h>

hkResult hkgVdbOrientationWidget::initialize( hkgVdbPlugin& plugin, hkVdbClient& client )
{
    updateBounds( *plugin.getWindow()->getContext() );
    return HK_SUCCESS;
}

hkResult hkgVdbOrientationWidget::deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client )
{
    return HK_SUCCESS;
}

void hkgVdbOrientationWidget::render( hkgDisplayContext& context ) const
{
    hkgViewport* v = context.getCurrentViewport();
    hkgCamera* c = v->getCamera();

    float m[16];
    float* res = &m[12];
    float ad[3];
    hkgMat4Identity( m );
    hkInt32 invy = ( v->getHeight() - ( 40 + m_options.m_yOffset ) );
    c->unProject( 40 + m_options.m_xOffset, invy, 0.2f, v->getWidth(), v->getHeight(), res );
    hkgVec3Sub( ad, c->getFromPtr(), res );
    float dist = hkgVec3Length( ad );
    float drawSize = c->computeIconVerticalDrawSize( dist, 32, v->getHeight() );
    context.pushMatrix();
    context.multMatrix( m );
    hkReal popScale = m_options.m_scale;
    const_cast< hkgVdbOrientationWidgetOptions& >( m_options ).m_scale *= drawSize;
    hkgVdbAxisDrawer::drawAxis( context, m_options );
    const_cast< hkgVdbOrientationWidgetOptions& >( m_options ).m_scale = popScale;
    context.popMatrix();

    updateBounds( context );
}

void hkgVdbOrientationWidget::updateBounds( hkgDisplayContext& context ) const
{
    hkgViewport* v = context.getCurrentViewport();
    int h = v->getHeight();

    // We always try to draw the axis in the same location on the screen, roughly taking up the same area
    // This isn't an exact calculation as that would depend on projection matrix, etc.
    // Could fix it later if it matters.
    m_bounds.m_minX = 0;
    m_bounds.m_maxX = 80;
    m_bounds.m_minY = ( h - 80 );
    m_bounds.m_maxY = h;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
