// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/2d/hkgVdb2dWidget.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbStatsHandler.h>

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/Utils/hkgVdbTextBoxDrawer.h>

#include <Graphics/Bridge/hkGraphicsBridge.h>
#include <Graphics/Bridge/StatGraph/hkgStatGraph.h>

//////////////////////////////////////////////////////////////////////////
/// Options for the hkgVdbDeprecatedStatBarGraphWidget.
//////////////////////////////////////////////////////////////////////////
struct HK_EXPORT_VDB hkgVdbDeprecatedStatBarGraphWidgetOptions : public hkgVdbDimensions
{
    HK_DECLARE_CLASS( hkgVdbDeprecatedStatBarGraphWidgetOptions, New );

    hkgVdbDeprecatedStatBarGraphWidgetOptions( hkgFont& font ) :
        m_onHoverTimerDisplayOptions( font )
    {
        // We set x/y to max to aid in determining if user sets them explicitly
        m_onHoverTimerDisplayOptions.m_x = HK_INT32_MAX;
        m_onHoverTimerDisplayOptions.m_y = HK_INT32_MAX;

        // By default we make the textbox transparent
        m_onHoverTimerDisplayOptions.m_upperLeftColor = 0;
        m_onHoverTimerDisplayOptions.m_lowerRightColor = 0;
        m_onHoverTimerDisplayOptions.m_borderColor = 0;
    }

    /// Options for drawing the on hover timer names.
    hkgVdbTextBoxDrawerOptions m_onHoverTimerDisplayOptions;
};

//////////////////////////////////////////////////////////////////////////
/// A widget which draws stats for the current frame as bars.
//////////////////////////////////////////////////////////////////////////


class HK_EXPORT_VDB hkgVdbDeprecatedStatBarGraphWidget : public hkgVdb2dWidget
{
public:
    HK_DECLARE_CLASS( hkgVdbDeprecatedStatBarGraphWidget, New, ReflectIdentity );
    hkgVdbDeprecatedStatBarGraphWidget();
    ~hkgVdbDeprecatedStatBarGraphWidget();

    //
    // hkgVdb2dWidget
    //

    virtual hkResult initialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult deinitialize( hkgVdbPlugin& plugin, hkVdbClient& client ) HK_OVERRIDE;
    virtual hkResult update( const hkgViewport& viewport, const hkgInputManager& input ) HK_OVERRIDE;
    virtual void render( hkgDisplayContext& context ) const HK_OVERRIDE;
    virtual void getToolTip( hkStringBuf& toolTipOut, bool verbose ) const HK_OVERRIDE;
    virtual hkgVdbInputTypes getSupportedInputs() const HK_OVERRIDE { return hkgVdbInputTypes::MOUSE; }
    virtual hkgVdbBounds getBounds() const HK_OVERRIDE { return m_bounds; }

    //
    // Control
    //

    /// Access the current options.
    hkgVdbDeprecatedStatBarGraphWidgetOptions& accessOptions() { return m_options; }

    /// Get the default font used to draw text.
    hkgFont& getDefaultFont() { return *m_defaultFont; }

    //
    // Internal use
    //

    void onPerfStatsReceivedSignal( const hkVdbStatsHandler::PerfStats& perfStats, hkVdbSignalResult& result );

protected:

    virtual hkResult enable() HK_OVERRIDE;
    virtual hkResult disable() HK_OVERRIDE;

    enum InteractionState
    {
        NONE,
        ZOOM_EXTENTS = ( 1 << 0 ),
        ZOOMING = ( 1 << 1 ),
        PANNING = ( 1 << 2 ),
    };

    hkBool32 applyZoom( hkgVdbPoint center, double scale ) const;
    hkBool32 applyTranslate( int delta ) const;
    void adjustForContext( hkgDisplayContext& context );
    hkgVdbPoint translateFromZoomedSpace( hkgVdbPoint mp ) const;
    void resetBounds() const;

    hkRefPtr<hkVdbClient> m_client;
    hkMonitorStreamAnalyzer::Node* m_timerNodeUnderMouse;
    mutable hkgVdbPoint m_zoomExtentsStart;
    mutable hkgVdbPoint m_lastZooming;
    mutable hkgVdbPoint m_lastPanning;
    mutable InteractionState m_state;
    hkRefPtr<hkgFont> m_defaultFont;
    mutable hkgVdbDeprecatedStatBarGraphWidgetOptions m_options;
    mutable hkgVdbBounds m_bounds;
    mutable hkgVdbBounds m_statGraphTimerBounds;
    mutable hkgVdbBounds m_zoomingBounds;
    mutable hkgVdbBounds m_zoomedBounds;
    struct TimerData
    {
        HK_DECLARE_CLASS( TimerData, New );
        hkMonitorStreamFrameInfo m_frameInfo;
        hkMonitorStream::CommandStreamConfig m_streamConfig;
        hkArray<hkMonitorStreamAnalyzer::ThreadRootNodes> m_threadRoots;
    };
    hkgVdbDataBuffer<TimerData> m_timerData;
    mutable hkgStatGraph m_statGraph;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
