// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/hkgVdbWidget.h>

struct hkgVdbWidgetRenderOptions;

//////////////////////////////////////////////////////////////////////////
/// Base class for 2d widget functionality.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkgVdb2dWidget : public hkgVdbWidget
{
public:
    HK_DECLARE_CLASS( hkgVdb2dWidget, ReflectIdentity );

    /// The widget must return the bounds in which it intends to draw.
    virtual hkgVdbBounds getBounds() const = 0;

    /// Set the common render state for drawing 2d widgets.
    static void setCommonRenderState( hkgDisplayContext& context );

    /// The common HKG_ENABLED_STATE for 2d widgets.
    static const HKG_ENABLED_STATE DEFAULT_2D_ENABLED_STATE = HKG_ENABLED_ALPHABLEND;

    /// The common HKG_CULLFACE_MODE for 2d widgets.
    static const HKG_CULLFACE_MODE DEFAULT_2D_CULLFACE_MODE = 0;

    /// The common HKG_BLEND_MODE for 2d widgets.
    static const HKG_BLEND_MODE DEFAULT_2D_BLEND_MODE = HKG_BLEND_MODULATE_OPAQUE_DEST;

    /// The common HKG_ALPHA_SAMPLE_MODE for 2d widgets.
    static const HKG_ALPHA_SAMPLE_MODE DEFAULT_2D_SAMPLE_MODE = HKG_ALPHA_SAMPLE_NORMAL;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
