// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Graphics/Common/hkGraphics.h>
#include <Graphics/Common/Window/hkgWindow.h>

#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/2d/hkgVdb2dWidget.h>
#include <VisualDebugger/VdbDisplay/Hkg/System/Widget/hkgVdbWidgetManager.h>

void hkgVdb2dWidget::setCommonRenderState(hkgDisplayContext& context)
{
    // Set default 2d draw state
    hkgViewport* ov = context.getOwner()->getWindowOrthoView();
    ov->setAsCurrent(&context);
    context.setCurrentSoleTexture(HK_NULL, HKG_TEXTURE_DECAL);
    context.matchState(
        (DEFAULT_2D_ENABLED_STATE) ? DEFAULT_2D_ENABLED_STATE : context.getEnabledState(),
        (DEFAULT_2D_CULLFACE_MODE) ? DEFAULT_2D_CULLFACE_MODE : context.getCullfaceMode(),
        (DEFAULT_2D_BLEND_MODE) ? DEFAULT_2D_BLEND_MODE : context.getBlendMode(),
        (DEFAULT_2D_SAMPLE_MODE) ? DEFAULT_2D_SAMPLE_MODE : context.getAlphaSampleMode()
    );
    context.setCurrentColorPacked(hkColor::NONE);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
