// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkxScene;
class hkxMesh;
class hkxNode;
class hkxIndexBuffer;
class hkxVertexBuffer;
class hkxMaterial;
class hkgDisplayObject;
class hkgGeometry;
class hkStreamWriter;

//////////////////////////////////////////////////////////////////////////
/// This utility offers several static methods for extracting scene data
/// from graphics data.
//////////////////////////////////////////////////////////////////////////

namespace hkgVdbObjectConversionUtil
{
    struct LitVert
    {
        hkVector4 m_position;
        hkVector4 m_normal;
    };

    hkRefNew<hkxVertexBuffer> createHkxVertexBuffer( const hkArrayView<LitVert> vertices );
    hkRefNew<hkxMesh> createHkxMesh( const hkgDisplayObject* displayObject, hkPointerMap< int, hkxMaterial* >& materialMap );
    hkRefNew<hkxMesh> createHkxMesh( const hkArrayView<hkgGeometry*> geometries, hkPointerMap< int, hkxMaterial* >& materialMap );
    hkRefNew<hkxIndexBuffer> createHkxIndexBuffer( const hkArrayView<hkUint32> indices, bool largeIndices );
    hkRefNew<hkxMaterial> createHkxMaterial( hkReal cb, hkReal cr, hkReal cg, hkReal ca );
    hkRefNew<hkxNode> createHkxNode( char* name, const int numChildren, const hkxMesh* mesh, const hkMatrix4& trmat );
    hkRefNew<hkxScene> createHkxScene( const hkArrayView<hkRefPtr<hkxMesh>> meshes, const hkArrayView<hkMatrix4> tmats );
    hkResult writeHkxScene( hkStreamWriter& writer, const hkxScene* scene );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
