// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HAVOK_VDB_NETWORK_CONNECTION_H
#define HAVOK_VDB_NETWORK_CONNECTION_H

#include <Common/Base/System/Io/Platform/Bsd/hkBsdSocket.h>
#include <VisualDebugger/VdbClient/hkVdbLiveConnection.h>

class hkChunkLoader;
class hkVdbCmdFifo;
class hkCommandHandler;
class hkStreamReader;
class hkStreamWriter;
class hkArrayStreamWriter;
class hkBufferedStreamReader;
struct hkVdbCmd;

class hkVdbNetworkConnection : public hkVdbLiveConnection
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY, hkVdbNetworkConnection );

    // Make a network connection. The owner (if given) will
    // be notified when 'step' chunks come in ( id(0) chunks )
    // with a windows message
    // Otherwise you can register for a Step Chunk callback
    hkVdbNetworkConnection(
        hkVdbCache* vdbCache,
        const char* machineName = HK_VDB_DEFAULT_MACHINE_NAME,
        int port = HK_VDB_DEFAULT_PORT,
        HWND owner = NULL );

    // Dtor will make sure that the current thread ends.
    ~hkVdbNetworkConnection();

    virtual hkVdbLiveConnection::Type getType() const  HK_OVERRIDE { return hkVdbLiveConnection::CONNECTION_NETWORK; }

        // Connect to a given machine and port.
        // It spawns a thread to setup the connection, so
        // do not try to retrieve commands until isConnected() is true;
    virtual void connect() HK_OVERRIDE;

    // Will wait for worker thread to finish and exit.
    // Called by dtor anyway.
    virtual void disconnect() HK_OVERRIDE;

    virtual bool isConnected() const HK_OVERRIDE;
    virtual bool isInConnectPhase() const HK_OVERRIDE;
    virtual bool didLastConnectFail() const HK_OVERRIDE;

    void setConnected( bool success );

    const char* getMachineName() { return m_machineName.cString(); }
    int getPortNumber() { return  m_portNumber; }

protected:

    virtual int readClientData( hkInt8* readBuffer, int size ) HK_OVERRIDE;
    virtual int writeClientData( hkInt8* commandsToSend, int size ) HK_OVERRIDE;

    void enableNotifications();
    static DWORD WINAPI NotifyThreadProc( LPVOID lpParam );

    // Network ID
    int m_portNumber;
    hkStringPtr m_machineName;

    // Network information handlers
    hkRefPtr<hkBsdSocket> m_socket;
    hkRefPtr<hkBufferedStreamReader> m_socketReader;

    // The worker thread
    bool volatile       m_connectFailed;
    bool volatile       m_inConnectPhase;
    HWND                m_owner; // The threads owner CWnd (if one) to receive step chunk notification

    struct ThreadInfo
    {
        class hkVdbNetworkConnection* m_parent;
        bool m_stillRunning;
    };

    ThreadInfo* m_threadInfo;
    HANDLE m_notifyThread;
};

#endif // HAVOK_VDB_NETWORK_CONNECTION_H

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
