// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HAVOK_VDB_MAIN_H
#define HAVOK_VDB_MAIN_H

#pragma once

//#ifndef HAVOK_VDB_API
//# define HAVOK_VDB_API __declspec(dllimport)
//#endif // else defined as __declspec(dllexport)
#define HAVOK_VDB_API  // nothing for the moment while still as a source include.

// !CK: Try and remove these in future
// Requires including way more that required.
// You may get away with not linking to the affected libs (base, math, geometry)
#include <Common/Base/hkBase.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>
#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamAnalyzer.h>
#include <Common/Base/System/Io/Socket/hkInetAddr.h>
#include <Common/Visualize/Shape/hkDisplayGeometry.h>
#include <Common/Visualize/hkDebugDisplayHandler.h>
#include <VisualDebugger/VdbClient/hkVdbCache.h>

//
// Havok Visual Debugger Module.
// Functions for init and registration at the end.


//
// Typedefs
//

#define HK_VDB_DEFAULT_PORT 25001
#define HK_VDB_DEFAULT_MACHINE_NAME "localhost"

// Window message based Notifications
#ifndef WM_USER
#define WM_USER 0x0400
#endif

#define WM_USER_HK_VDB_SOCKET_NOTIFY        (WM_USER + 0x1234)
typedef unsigned int HK_VDB_NOTICATION_ACTION;
#define HK_VDB_NOTICATION_ERROR  0 // bad stuff happened, and probably has disconnect due to it.
#define HK_VDB_NOTICATION_NONE   1 //did stuff, but nothing to be worried about
#define HK_VDB_NOTICATION_READ_CHUNKS 2  // read chunks, at least one of which was a step chunk
#define HK_VDB_NOTICATION_WROTE_CHUNKS 3 // write some command chunks
#define HK_VDB_NOTICATION_DISCONNECTED 4 // network connection is gone
#define HK_VDB_NOTICATION_CONNECTED 5 // network connect has succeeded
#define HK_VDB_NOTICATION_WARNING 6 // did stuff, but bad stuff might have happened so warn about it

// User cameras
#define HK_VDB_MAX_CAMERA_NAME_LEN 256
struct hkVdbCamera
{
    char name[HK_VDB_MAX_CAMERA_NAME_LEN];

    float from[3];
    float to[3];
    float up[3];

    float farPlane;
    float nearPlane;
    float fov;
};

// A colored point (matches hkgDisplayVertex)
struct hkVdbDisplayPoint
{
    hkVdbDisplayPoint() : m_userData(0) {}
    HK_ALIGN_FLOAT( float pos[3] );
    unsigned int color;  //0xAARRGGBB
    hkUint64 m_userData;
};

// A colored triangle
struct hkVdbDisplayTriangle
{
    float p1[3];
    float p2[3];
    float p3[3];
    unsigned int color; //0xAARRGGBB
};

// A bone
struct hkVdbDisplayBone
{
    hkVector4 start;
    hkVector4 end;
    hkQuaternion orientation;
    unsigned int color;
};

struct hkVdbDisplayText
{
    hkColor::Argb m_color;
    hkStringPtr m_text;
    hkUint64 m_userData;
};

struct hkVdbDisplay3dText : public hkVdbDisplayText
{
    HK_ALIGN_FLOAT( float m_pos[3] );
};

// Basic info about a movie file
struct hkVdbReplayInfo
{
    hkVdbReplayInfo()
    {
        reset();
    }

    void reset()
    {
        m_numFrames = 0;
        m_offsets.setSize(0);
        m_times.setSize(0);
        m_fileSize = 0;
        m_startingFrame = 0;
        m_startingOffset = 0;
        m_startingTime = 0.0f;
        m_currentFrame = hkVdbCache::Iterator( -1 );
        m_currentChunk = hkVdbFrame::Iterator( -1 );
    }

    int             m_numFrames;
    hkArray<int>    m_offsets;
    hkArray<hkReal> m_times;
    int             m_fileSize;

    // Information for computing absolute values from relative
    int             m_startingFrame;
    int             m_startingOffset;
    hkReal          m_startingTime;

    // When using cache, this contains current replay data
    hkVdbCache::Iterator m_currentFrame;
    hkVdbFrame::Iterator m_currentChunk;
};

namespace hkVdbCustomServerCommands
{
    enum Enum
    {
        HK_LOAD_VERSIONED_STAT_MAPS,
        HK_DEBUG_TAG
    };
};

class hkMeshBody;
class hkVisualDebugger;
class hkVdbDestructionHandler;
class hkResource;

// User Camera callback
typedef void (HK_CALL *hkVdbCameraCallback)(const hkVdbCamera& c, void* userHandle);

// User Behavior callbacks
typedef void (HK_CALL *hkVdbBehaviorUpdateCallback)(const hkArray<int>& wordIdx, const hkArray<int>& wordStack, const hkArray<int>& quadIdx, const hkArray<hkVector4>& quadStack,
                                                      const hkArray<char*>& activeNodes, const hkArray<int>& activeStateIds, const hkArray<int>& activeTransitionInfo, const hkArray<hkTransform>& transforms);
typedef void (HK_CALL *hkVdbFindBehaviorCallback)(const hkArray<char*>& behaviors, const hkArray<int>& ids);
typedef void (HK_CALL *hkVdbLiveObjectReceivedCallback)(hkReferencedObject* object, void* callbackHandle);
typedef void (HK_CALL *hkVdbDataObjectReceivedCallback)(::hkResource* object, void* callbackHandle);

// Step callback (from the deserialization)
typedef void (HK_CALL *hkVdbStepCallback)( float frameTimeDT, void* callbackHandle);

// Version info callback (from the deserialization) so that the app
// can choose to do something more interesting with the info.
// The version info is the first thing to be desearlized so you can use it
// as a sort of connect callback too if you want.
typedef void (HK_CALL *hkVdbVersionCallback)( const char* platformString, const char* compilerString, unsigned int remoteProtocolVersion, unsigned int m_remoteMinProtocolVersion, void* callbackHandle);

// Callback raised after a connection has been reset for recording.  Recording destroys and re-creates
// the connection to the server.  Use this callback to reflect previous viewer state to the server.
typedef void (HK_CALL *hkVdbReflectViewerStateCallback)( void* callbackHandle );

// Statistics handling (perf and mem)
typedef void (HK_CALL *hkVdbStatCallback)( const hkArray<hkMonitorStreamAnalyzer::Node*>& nodes, const hkArray<const char*>& nodePaths, void* userHandle, int numThreads);
typedef void (HK_CALL *hkVdbStatSavedCallback)( bool success, const char* filename, int frames, void* userData);

// Plugins (server side viewers) that can be registered and enabled and disabled though the plugin calls.
typedef void (HK_CALL *hkVdbPluginRegisterCallback)(const char* name, int id, void* userHandle);
typedef void (HK_CALL *hkVdbPluginSelectCallback)(int id, void* userHandle);

// Support for Havok Destruction
typedef void (HK_CALL *hkVdbDestructionRegisterCallback)(hkVdbDestructionHandler* handler, hkUint64 id, void* userHandle);

// Connection status callbacks.
// For the step callback, status is true for the first step.
// For the closed callback, status is true if the thread exited normally (false for server close etc)
typedef void (HK_CALL *hkVdbConnectionBoolCallback)(bool status, void* userHandle);

// Display geometry callbacks.
typedef void ( HK_CALL *hkVdbGeomAddedCallback )( const hkArrayBase<hkDisplayGeometry*>& geometries, const hkTransform& transform, hkUint64 id, int tag, const hkColor::Argb* color, hkDisplayGeometryFlags flags, void* callbackHandle );
typedef void (HK_CALL *hkVdbGeomInstanceAddedCallback)(hkUint64 instanceId, const hkTransform& transform, hkUint64 id, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomPickableCallback)(hkBool isPickable, hkUint64 id, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomShownCallback)(hkUint64 id, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomHiddenCallback)(hkUint64 id, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomAllHiddenCallback)(bool removeRefs, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomColorCallback)(unsigned int color, hkUint64 id, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomTransparencyCallback)(float color, hkUint64 id, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomUpdateCallback)(const hkMatrix4& transform, hkUint64 id, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomUpdateVertsCallback)( hkUint64 id, const hkArray<hkVector4>& newVerts, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomSkinnedCallback)(hkUint64* ids, int numIds, const hkMatrix4* poseWorldSpace, int numPoseWorldSpace, const hkMatrix4& worldFromModel, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomRemovedCallback)(hkUint64 id, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbGeomsHighlightedCallback)(const hkArrayView<hkUint64>& ids, bool selected, void* callbackHandle);

// Color == 0x00RRGGBB
typedef void (HK_CALL *hkVdbConsoleTextCallback)(const char* string, unsigned int color, hkUint64 id, int tag, void* callbackHandle);
typedef void (HK_CALL *hkVdbConsoleText3DCallback)(const char* string, unsigned int color, float pos[3], hkUint64 id, int tag, void* callbackHandle);

// Serialization objects and classes
typedef void (HK_CALL *hkVdbInspectTopLevelCallback)( hkUint64 ptrID, hkUint64 classID, hkUint64 tagId, bool added, void* callbackHandle);
typedef void (HK_CALL *hkVdbInspectObjectCallback)( hkUint64 ptrID, void* data, void* callbackHandle);
typedef void (HK_CALL *hkVdbInspectSnapshotCallback)( hkUint8 bytesInPointer, hkUint8 littleEndian, hkInt32 snapShotSize, char* snapShot, void* callbackHandle ); // snapshot data valid during callback

// Memory snapshot
class hkStreamReader;
typedef void (HK_CALL *hkVdbMemorySnapshotCallback)( hkStreamReader* s, hkUint32 size, void* callbackHandle );

//
// Callback registration
// The Connection callbacks may be raised from within a separate thread, so be thread safe with your callback code.
//

HAVOK_VDB_API void HK_CALL hkVdbSetVersionCallback( hkVdbVersionCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetReflectViewerStateCallback( hkVdbReflectViewerStateCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetStepCallback( hkVdbStepCallback c, void* userHandle = HK_NULL );

HAVOK_VDB_API void HK_CALL hkVdbSetPerfStatCallback( hkVdbStatCallback c, int i /*can handle up to 4*/, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetMemStatCallback( hkVdbStatCallback c, int i /*can handle up to 4*/, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetTextCallback( hkVdbConsoleTextCallback  c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetText3DCallback( hkVdbConsoleText3DCallback  c, void* userHandle = HK_NULL );

HAVOK_VDB_API void HK_CALL hkVdbSetViewerRegCallback( hkVdbPluginRegisterCallback c, void* userHandle = HK_NULL);
HAVOK_VDB_API void HK_CALL hkVdbSetViewerSelectCallback( hkVdbPluginSelectCallback c, void* userHandle = HK_NULL);

HAVOK_VDB_API void HK_CALL hkVdbSetDestructionRegCallback( hkVdbDestructionRegisterCallback c, void* userHandle = HK_NULL);

HAVOK_VDB_API void HK_CALL hkVdbSetGeomAddedCallback( hkVdbGeomAddedCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetGeomInstanceAddedCallback( hkVdbGeomInstanceAddedCallback c, void* userHandle = HK_NULL);
HAVOK_VDB_API void HK_CALL hkVdbSetGeomPickableCallback( hkVdbGeomPickableCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetGeomShownCallback( hkVdbGeomShownCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetGeomHiddenCallback( hkVdbGeomHiddenCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetGeomAllHiddenCallback( hkVdbGeomAllHiddenCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetGeomColorCallback( hkVdbGeomColorCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetGeomTransparencyCallback( hkVdbGeomTransparencyCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetGeomUpdateCallback( hkVdbGeomUpdateCallback c, void* userHandle = HK_NULL);
HAVOK_VDB_API void HK_CALL hkVdbSetGeomUpdateVertsCallback( hkVdbGeomUpdateVertsCallback c, void* userHandle = HK_NULL);
HAVOK_VDB_API void HK_CALL hkVdbSetGeomSkinnedCallback( hkVdbGeomSkinnedCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetGeomRemovedCallback( hkVdbGeomRemovedCallback c, void* userHandle = HK_NULL );

HAVOK_VDB_API void HK_CALL hkVdbSetGeomsHighlightedCallback( hkVdbGeomsHighlightedCallback c, void* userHandle = HK_NULL );

HAVOK_VDB_API void HK_CALL hkVdbSetCameraAddedCallback( hkVdbCameraCallback c, void* userHandle = HK_NULL);
HAVOK_VDB_API void HK_CALL hkVdbSetCameraChangedCallback( hkVdbCameraCallback c, void* userHandle = HK_NULL);

HAVOK_VDB_API void HK_CALL hkVdbSetMemorySnapshotCallback( hkVdbMemorySnapshotCallback c, void* userHandle = HK_NULL);

HAVOK_VDB_API void HK_CALL hkVdbSetBehaviorVariableCallback( hkVdbBehaviorUpdateCallback c, void* userHandle = HK_NULL);
HAVOK_VDB_API void HK_CALL hkVdbSetFindBehaviorCallback( hkVdbFindBehaviorCallback c, void* userHandle = HK_NULL);
HAVOK_VDB_API void HK_CALL hkVdbSetDataObjectReceivedCallback( hkVdbDataObjectReceivedCallback c, void* userHandle = HK_NULL );
HAVOK_VDB_API void HK_CALL hkVdbSetLiveObjectReceivedCallback( hkVdbLiveObjectReceivedCallback c, void* userHandle = HK_NULL );

//
// Control functions
//

HAVOK_VDB_API bool HK_CALL hkVdbInit();
HAVOK_VDB_API HK_VDB_NOTICATION_ACTION HK_CALL hkVdbProcess(); // this will close connections on error states, and time out
HAVOK_VDB_API bool HK_CALL hkVdbIsCaching();
HAVOK_VDB_API void HK_CALL hkVdbSetCurrentChunkFileOffset(int offset);
HAVOK_VDB_API void HK_CALL hkVdbUpdateGeometries(int startFrame, int endFrame);
HAVOK_VDB_API bool HK_CALL hkVdbIsCachingGeometries();
HAVOK_VDB_API hkUint64 HK_CALL hkVdbGetCacheGeometryId( hkUint64 id );
HAVOK_VDB_API hkUint64 HK_CALL hkVdbGetCacheGeometryStreamId( hkUint64 id );
HAVOK_VDB_API void HK_CALL hkVdbDoFrameAt(int offset);
HAVOK_VDB_API bool HK_CALL hkVdbGoToStartNoReload(const char* filename);
HAVOK_VDB_API hkInt32 HK_CALL hkVdbCacheFrameLocations();
HAVOK_VDB_API void HK_CALL hkVdbSetSilentMode(bool silent); // disables some info callbacks etc. Used for reseting an already open movie, or back stepping a movie
HAVOK_VDB_API void HK_CALL hkVdbSetContinueOnUnknownClass(bool keepGoing); // whether or not to stop playback if an unknown class is encounted in the movie.

HAVOK_VDB_API bool HK_CALL hkVdbIsLayoutSet();

HAVOK_VDB_API HK_VDB_NOTICATION_ACTION HK_CALL hkVdbHandleNotifications(LPARAM lParam); // handle any notifcation (WM_USER_HK_VDB_SOCKET_NOTIFY) messages that got sent to the main program. May cause network connection changes etc, and may call process() if there is data to read (you will get callbacks). False == check error state
HAVOK_VDB_API bool HK_CALL hkVdbQuit();


HAVOK_VDB_API float HK_CALL hkVdbGetCurrentContinousTime(); // from last connect / record start / play start / reset counters
HAVOK_VDB_API void HK_CALL hkVdbSetCurrentContinousTime(float time); // used when jumping to frames
HAVOK_VDB_API int HK_CALL hkVdbGetCurrentFrameCount(); // from last connect / record start / play start / reset counters
HAVOK_VDB_API float HK_CALL hkVdbGetServerFps(); // Gets the rate at which steps are being received from the server
HAVOK_VDB_API void HK_CALL hkVdbSetCurrentFrame(int frameNumber); // used when jumping to frames
HAVOK_VDB_API bool HK_CALL hkVdbResetCurrentTime(); // // so that we can sync our timer with the DLLs etc. Just does the timer.
HAVOK_VDB_API bool HK_CALL hkVdbResetCurrentCounters(); // so that we can sync our timer with the DLLs etc. Does step count and the timer.
HAVOK_VDB_API int HK_CALL hkVdbGetCurrentFrameSize(); // since last step(), in bytes
HAVOK_VDB_API void HK_CALL hkVdbDisableOverrideFrameTimeIfZero(); // disables the override that sets the frame time to 1/60 if the server sends 0
HAVOK_VDB_API int HK_CALL hkVdbGetCurrentBufferedFrameCount();
HAVOK_VDB_API void HK_CALL hkVdbSaveBuffer( const char* filename );

// Create a connection to a given IP and socket port number
// Returns true if initialized ok (this does not mean that you have connected though as it is in a separate thread.)
HAVOK_VDB_API bool HK_CALL hkVdbStartNetwork(const char* address, int port, HWND messageListener = HK_NULL, float bufferDurationInMs = -1.0f);
// Starting a recording to file will force a reconnect to the server.
HAVOK_VDB_API bool HK_CALL hkVdbStartMovieRecord(const char* filename);
HAVOK_VDB_API bool HK_CALL hkVdbStartMovieRecordToCache(const char* filename, hkVdbReplayInfo* infoOut);
HAVOK_VDB_API bool HK_CALL hkVdbStartMemoryConnection(hkVisualDebugger* server);
HAVOK_VDB_API bool HK_CALL hkVdbMovieViewerFilter(int id, bool filter); // don't pass on info from given filter even if it is on (used with movies)
HAVOK_VDB_API bool HK_CALL hkVdbMovieViewerFilterStatus(int id);
HAVOK_VDB_API void HK_CALL hkVdbStartMoviePlayback(const char* filename, hkVdbReplayInfo* infoOut);
HAVOK_VDB_API bool HK_CALL hkVdbStartMoviePlaybackFromCache(const char* filename, hkVdbReplayInfo* infoIn);
HAVOK_VDB_API void HK_CALL hkVdbStartLivePlayback(hkVdbReplayInfo* infoOut);
HAVOK_VDB_API void HK_CALL hkVdbStopLivePlayback();
HAVOK_VDB_API unsigned int HK_CALL hkVdbCacheMovieFrame();
HAVOK_VDB_API int HK_CALL hkVdbGetFileSize();
HAVOK_VDB_API bool HK_CALL hkVdbResetToBeginning(const char* filename);

// Version information. Valid after first step of a movie playback or network.
HAVOK_VDB_API const char* HK_CALL hkVdbGetRemotePlatformString();
HAVOK_VDB_API int HK_CALL hkVdbGetRemoteProtocolVersion(); // version read from file or on the network from server
HAVOK_VDB_API int HK_CALL hkVdbGetRemoteProtocolMinimumCompatible();

// Always valid. These allow the client to do some error / dll loading based on version of server etc.
HAVOK_VDB_API const char* HK_CALL hkVdbGetLocalBuildDate(); // returns __DATE__ as given by the compiler when the DLL was built.
HAVOK_VDB_API int HK_CALL hkVdbGetLocalProtocolVersion();
HAVOK_VDB_API int HK_CALL hkVdbGetLocalProtocolMinimumCompatible();


// Connection status for Movies
#define HK_VDB_MOVIE_NONE      0   // closed or never opened
#define HK_VDB_MOVIE_PLAYING   1
#define HK_VDB_MOVIE_RECORDING 2
HAVOK_VDB_API unsigned int HK_CALL hkVdbStatusMovie(); // returns int with one of the above values

// Connection status for Networks
#define HK_VDB_NETWORK_NONE       0 // closed or never opened
#define HK_VDB_NETWORK_CONNECTING 1
#define HK_VDB_NETWORK_CONNECTED  2
#define HK_VDB_NETWORK_FAILED     3
#define HK_VDB_NETWORK_CONNECTED_TO_MEMORY_STREAM 4
HAVOK_VDB_API unsigned int HK_CALL hkVdbStatusNetwork(); // returns int with one of the above values

// Close current connection and release any extra memory etc
HAVOK_VDB_API bool HK_CALL hkVdbCloseNetwork();
HAVOK_VDB_API bool HK_CALL hkVdbCloseMovie();

// Viewers (server side plugins)
HAVOK_VDB_API bool HK_CALL hkVdbNetworkCreateViewer(int id);
HAVOK_VDB_API bool HK_CALL hkVdbNetworkGetStateViewer(int id, bool& state);
HAVOK_VDB_API bool HK_CALL hkVdbNetworkToggleStateViewer(int id);
HAVOK_VDB_API bool HK_CALL hkVdbNetworkDeleteViewer(int id);

// Immediate mode. Callbacks can be a bit trouble some for these, so
// access to a pre buffered version is available here:
HAVOK_VDB_API void HK_CALL hkVdbImmForceClear();
HAVOK_VDB_API hkArray<hkVdbDisplayPoint>* HK_CALL hkVdbImmGetCurrentLineList();
HAVOK_VDB_API const hkArray<hkVdbDisplayPoint>* HK_CALL hkVdbImmGetCurrentPoints();
HAVOK_VDB_API const hkArray<hkVdbDisplayPoint>* HK_CALL hkVdbImmGetCurrentThickPoints();
HAVOK_VDB_API const hkArray<hkVdbDisplayBone>* HK_CALL hkVdbImmGetCurrentBones();
HAVOK_VDB_API const hkArray<hkVdbDisplayTriangle>* HK_CALL hkVdbImmGetCurrentTriangles();

// Statistics
HAVOK_VDB_API bool HK_CALL hkVdbHasPerfStats();
HAVOK_VDB_API bool HK_CALL hkVdbHasMemStats();
HAVOK_VDB_API float HK_CALL hkVdbGetPerfStatMultiplierToMilliseconds();

#define HK_VDB_STAT_RECORD_TXT 0
#define HK_VDB_STAT_RECORD_TGA 1
#define HK_VDB_STAT_RECORD_BIN 2
// If frames == 0 or 1, will just save record current frame. If > 1, will auto stop after the given period. In both cases, will call the given callback when done.
HAVOK_VDB_API void HK_CALL hkVdbStartPerfStatRecording(const char* filename, int fileType, int frames, hkVdbStatSavedCallback callback, void* callbackHandle);
HAVOK_VDB_API bool HK_CALL hkVdbIsPerfStatRecording();

// Pause will only pause the 'current frame'. Any recording will continue as normal.
HAVOK_VDB_API bool HK_CALL hkVdbIsPerfStatPaused();
HAVOK_VDB_API void HK_CALL hkVdbPerfStatPause();
HAVOK_VDB_API void HK_CALL hkVdbPerfStatContinue();


HAVOK_VDB_API const hkMonitorStreamAnalyzer::Node* HK_CALL hkVdbGetLastPerfStatRootNode();
HAVOK_VDB_API hkMonitorStreamAnalyzer::Node* HK_CALL hkVdbGetLastPerfStatRootNodeUncondensed(hkArray<hkMonitorStreamAnalyzer::ThreadRootNodes>& nodeThreadPairs, hkMonitorStreamFrameInfo& frameInfoOut); // need to delete this one when done with it (it is created for you)
HAVOK_VDB_API const hkMonitorStreamAnalyzer::Node* HK_CALL hkVdbGetLastMemStatRootNode();
// use the following during a connection, the vdb will raise a callback at
// the start of connection (version callback) so you can call set then to init.
// channel == callback number
HAVOK_VDB_API void HK_CALL hkVdbSetPerfStatEnabled(int channel, const char* name, bool on);
HAVOK_VDB_API void HK_CALL hkVdbSetMemStatEnabled(int channel,const char* name, bool on);
HAVOK_VDB_API void HK_CALL hkVdbSetPerfStatEnabledGroup(int channel, const char* const* names, int numNames);
HAVOK_VDB_API void HK_CALL hkVdbSetMemStatEnabledGroup(int channel, const char* const* names, int numNames);
HAVOK_VDB_API const hkArray<hkStringPtr>* HK_CALL hkVdbGetMemStatEnabledGroup(int channel);
HAVOK_VDB_API const hkArray<hkStringPtr>* HK_CALL hkVdbGetPerfStatEnabledGroup(int channel);
HAVOK_VDB_API void HK_CALL hkVdbPerfStatsToString(hkOstream& streamOut, hkMonitorStreamAnalyzer::CombinedThreadSummaryOptions& options);
HAVOK_VDB_API void HK_CALL hkVdbSetPerfStatGetCurrentStreamConfig(hkMonitorStream::CommandStreamConfig& configOut);

// Mouse spring style feedback to the server (game)
HAVOK_VDB_API bool HK_CALL hkVdbMousePickStart(hkUint64 objectID, const float* pos); // vec, 3 elems, for world space pos
HAVOK_VDB_API bool HK_CALL hkVdbMousePickDrag(const float* newPos); // vec, 3 elems, for newPos in world space
HAVOK_VDB_API bool HK_CALL hkVdbMousePickEnd();

// Behavior
HAVOK_VDB_API bool HK_CALL hkVdbRequestBehaviorList();
HAVOK_VDB_API bool HK_CALL hkVdbAttachToBehavior(const char * behavior, int id);
HAVOK_VDB_API void HK_CALL hkVdbSendObject( hkReferencedObject* object );
HAVOK_VDB_API void HK_CALL hkVdbSetSendObjectRestricted( bool usable );

// Movie cameras. We can save the user camera from the client GUI to the movie
// so that we can be guided to a particular problem area. Matched by name on input
// so just use the same name over and over per frame if you like.
HAVOK_VDB_API const hkArray<hkVdbCamera*>* HK_CALL hkVdbGetCameraList();
HAVOK_VDB_API bool HK_CALL hkVdbMovieRecordCamera(const hkVdbCamera& cam);

// Get the last error string. Reset at the start of each call to the VDB.
HAVOK_VDB_API const char* HK_CALL hkVdbGetLastError();

#endif //HAVOK_VDB_MAIN_H

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
