// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HAVOK_VDB_LIVE_CONNECTION_H
#define HAVOK_VDB_LIVE_CONNECTION_H

#include <VisualDebugger/VdbClient/hkVdbCache.h>

class hkArrayStreamWriter;

/// Interface for connections that can send and receive information between a client and a server
class hkVdbLiveConnection
{
public:

    /// The type of connection
    enum Type
    {
        /// Type not known
        CONNECTION_UNKNOWN,
        CONNECTION_NETWORK,
        CONNECTION_MEMORY_STREAM
    };

    hkVdbLiveConnection( hkVdbCache* vdbCache );
    virtual ~hkVdbLiveConnection() {}

    // Gets the connection's type
    virtual hkVdbLiveConnection::Type getType() const { return hkVdbLiveConnection::CONNECTION_UNKNOWN; }

    /// Connects the connection.
    virtual void connect();
    /// Disconnect the connection.
    virtual void disconnect();
    /// Returns true if connected, false otherwise
    virtual bool isConnected() const = 0;
    /// Returns true a connection is trying to be established but hasn't succeeded yet, false otherwise.
    virtual bool isInConnectPhase() const { return false; }
    /// Returns true if the last connection attempt failed, false otherwise.
    virtual bool didLastConnectFail() const { return false; }

    /// Read a chunk from the connection.  May block until a full chunk is read, depends on implementation.
    const hkVdbCmd* readChunk();

    /// Gets a stream to write vdb commands back to the server
    hkStreamWriter* getOutStream();

    /// Flush the out stream to the server
    bool flushOutStream( bool force = false );

protected:

    /// Reads data from the client
    virtual int readClientData( hkInt8* readBuffer, int size ) = 0;
    /// Write data to the client
    virtual int writeClientData( hkInt8* commandsToSend, int size ) = 0;

    hkVdbCache* m_vdbCache;

    hkArray<char> m_outgoingBuffer;
    hkRefPtr<hkArrayStreamWriter> m_outgoingStream;

    friend struct hkVdbFrame;
};

#endif // HAVOK_VDB_LIVE_CONNECTION_H

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
