// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HAVOK_VDB_CONSOLE_HANDLER_H
#define HAVOK_VDB_CONSOLE_HANDLER_H

class hkVdbConsoleHandler
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DISPLAY, hkVdbConsoleHandler );

    hkVdbConsoleHandler() :  m_textCallback(HK_NULL), m_textHandle(HK_NULL), m_text3DCallback(HK_NULL), m_text3DHandle(HK_NULL) {}

    void setTextHandler(hkVdbConsoleTextCallback c, void* userHandle) { m_textCallback = c; m_textHandle = userHandle; }
    void setText3DHandler(hkVdbConsoleText3DCallback c, void* userHandle) { m_text3DCallback = c; m_text3DHandle = userHandle; }

    void addText( const char* str, unsigned int color, hkUint64 id, int tag )
    {
        if (m_textCallback) m_textCallback( str, color, id, tag, m_textHandle );
    }

    void addText3D( const char* str, unsigned int color, float pos[3], hkUint64 id, int tag )
    {
        if (m_text3DCallback) m_text3DCallback( str, color, pos, id, tag, m_text3DHandle );
    }

protected:

    hkVdbConsoleTextCallback m_textCallback;
    void* m_textHandle;

    hkVdbConsoleText3DCallback m_text3DCallback;
    void* m_text3DHandle;
};

#endif

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
