// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include "pch.h"
PRAGMA_WARNING_PUSH
#include <llvm/Support/Path.h>
#include <llvm/Support/FileSystem.h>
PRAGMA_WARNING_POP

#include "utils/TkbmsRegistry.h"
#include "utils/StlUtils.h"
#include "utils/ProfilePoint.h"
#include "utils/Logger.h"
#include "utils/RuntimeError.h"
#include "llvm/Support/raw_ostream.h"

void scanDirectoryForTkbms(const std::string& rootDirectoryIn, TkbmsRegistry& tkbms
    , const std::set<std::string>& enabledProducts, const std::set<std::string>& enabledPlatforms, bool explicitReflect
    , bool excludeInternal, const std::vector<std::string>& excludeDirsIn, std::vector<std::string>& inputFilesOut)
{
    std::vector<std::string> excludeDirs;
    for(auto& s: excludeDirsIn)
    {
         excludeDirs.push_back(/*rootDirectory + "/" +*/ Filesystem::fixSeparatorsAndRemoveLeadingDot(s));
    }

    std::string rootDirectory = Filesystem::absoluteCanonicalPath(rootDirectoryIn);

    // Scan the filesystem to create the list of files to scan
    {
        HIDDEN_PROFILE_POINT();
        tkbms.scanFilesystem(rootDirectory, excludeDirs);
        tkbms.removeEntries(TkbmsRegistry::KEY_PLATFORM, "!REFLECT");
        tkbms.removeEntries(TkbmsRegistry::KEY_PLATFORM, "NONE");
        tkbms.removeEntries(TkbmsRegistry::KEY_PRODUCT, "NONE");
        if(enabledProducts.size() > 0)
        {
            tkbms.keepEntries(TkbmsRegistry::KEY_PRODUCT, enabledProducts);
        }
        if (enabledPlatforms.size() > 0)
        {
            tkbms.keepEntries(TkbmsRegistry::KEY_PLATFORM, enabledPlatforms);
        }

        // Sometimes we strip these to keep file size down
        if(excludeInternal)
        {
            hkLog.info("Excluding internal headers from generation\n");
            tkbms.removeEntries(TkbmsRegistry::KEY_VISIBILITY, "INTERNAL");
        }

        if(explicitReflect)
        {
            std::set<std::string> v;
            v.insert("REFLECT");
            tkbms.keepEntries(TkbmsRegistry::KEY_PLATFORM, v);
        }

        for(TkbmsRegistry::EntryMap::const_iterator cit = tkbms.tkbmsEntries.begin(); cit != tkbms.tkbmsEntries.end(); ++cit)
        {
            inputFilesOut.push_back(Filesystem::fixSeparatorsAndRemoveLeadingDot(cit->first));
        }

        PROFILE_POINT(TkbmsScan);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
