// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef TKBMS_REGISTRY_H
#define TKBMS_REGISTRY_H

#include "Filesystem.h"

class TkbmsRegistry
{
    public:

        enum KeyType
        {
            KEY_PLATFORM,
            KEY_PRODUCT,
            KEY_VISIBILITY
        };

        struct Entry
        {
            Entry() { }
            Entry(const std::string& fullTkbms);

            bool has(KeyType key, const std::string& value);
            bool matches(KeyType key, const std::set<std::string>& values);
            bool isValid() const;
            bool isProbablyTKBMS() const;
            std::string printableValue(KeyType key) const;

            std::vector<std::string> platform;
            std::vector<std::string> product;
            std::string visibility;
            std::string fullTkbms;
            bool requireAllProducts;
        };

        TkbmsRegistry(const std::string& projectProduct);

        typedef std::map<std::string, Entry, bool(*)(const std::string&,const std::string&)> EntryMap;

        void scanFilesystem(const std::string& project, const std::vector<std::string>& excludeDirs);
        bool scanSingleFile(const std::string& filename); // returns true if the file was successfully added to db

        void removeEntries(KeyType key, const std::string& value);
        void keepEntries(KeyType key, const std::set<std::string>& values);
        const Entry& getTkbmsEntry(const std::string& file);
        bool tryGetTkbmsEntry(const std::string& file, TkbmsRegistry::Entry& entryOut);

        static std::string readTkbmsFrom(const std::string& file);
        static std::string readTkbmsFrom(const std::string& file, bool& hasOldExcludeTag);

        std::string getProjectProduct() const;

        EntryMap tkbmsEntries;
    private:
        std::string projectProduct;
};

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
