// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef TEXT_BUILDER_H
#define TEXT_BUILDER_H

PRAGMA_WARNING_PUSH
#include <sstream>
#include <vector>
#include <set>
#include <utility>
#include <memory>
PRAGMA_WARNING_POP

class TextBuilder
{
    public:

        class Section
        {
            public:

                virtual ~Section();
                virtual Section& append(const std::string& str) = 0;
                virtual Section& append(const char* fmt, ...) = 0;
                virtual bool isEmpty() const = 0;
                virtual void format(std::string& out) const = 0;
                std::string toString() const;
        };

        class VerbatimSection : public Section
        {
            public:

                virtual Section& append(const std::string& str);
                virtual Section& append(const char* fmt, ...);
                virtual bool isEmpty() const { return m_data.tellp() == std::streampos(0); }
                virtual void format(std::string& out) const { out += m_data.str(); }

            protected:

                mutable std::ostringstream m_data;
        };

        class CodeSection : public Section
        {
            public:

                virtual Section& append(const std::string& str);
                virtual Section& append(const char* fmt, ...);
                virtual bool isEmpty() const { return m_lines.empty(); }
                virtual void format(std::string& out) const;

            private:

                std::vector<std::string> m_lines;
        };

        class DeclarationSection : public VerbatimSection
        {
            public:

                virtual Section& append(const std::string& str);
                virtual Section& append(const char* fmt, ...);

            protected:

                std::set<std::string> m_decls;
        };

        class IncludeSection : public DeclarationSection
        {
            public:
                enum IncludeStatementType
                {
                    USE_ANGLE_BRACKETS = 0,
                    USE_QUOTES = 1
                };
                IncludeSection(const std::vector<std::string>& includePaths, const std::string& ifGuard = "", IncludeStatementType statementType = USE_ANGLE_BRACKETS)
                    : m_includePaths(includePaths), m_ifGuard(ifGuard), m_statementType(statementType) {}

                virtual Section& append(const std::string& str);
                virtual Section& append(const char* fmt, ...);
                virtual void format(std::string& out) const;

            private:

                const std::vector<std::string>& m_includePaths;
                const std::string m_ifGuard;
                IncludeStatementType m_statementType;
        };

        class GuardedSection : public DeclarationSection
        {
            public:

                GuardedSection(const std::string& prefix) : m_prefix(prefix) { }

                virtual Section& append(const std::string& str);
                virtual Section& append(const char* fmt, ...);

            private:

                const std::string m_prefix;
        };

        TextBuilder();

        Section& operator[](const std::string& section);
            /// Takes the ownership of section
        Section& addSection(const std::string& name, Section* section);

        std::string format();

        bool isEmpty() const;

    private:

        std::shared_ptr<Section> findSection(const std::string& name);

        // We can't use a map<> here because we want to preserve the order of insertion (there shouldn't be more than ~5 sections anyway...)
        std::vector< std::pair< std::string, std::shared_ptr<Section> > > m_sections;
};


#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
