// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename T>
std::string joinStrings(const std::vector<T>& objects, std::string (T::*member), const std::string& delim)
{
    std::string res;
    if(!objects.empty())
    {
        for(std::size_t i = 1; i < objects.size(); ++i)
            res += (objects[i - 1].*member) +  delim;

        res += (objects.back().*member);
    }
    return res;
}

template<typename ForwardIterator>
std::string joinStrings(ForwardIterator begin, ForwardIterator end, const std::string& delim)
{
    std::string res;

    if(begin != end)
    {
        ForwardIterator it = begin;
        res = *it++;
        for(; it != end; ++it)
        {
            res += delim;
            res += *it;
        }
    }

    return res;
}

inline std::string replaceAll(const std::string& input, const std::string& search, const std::string& replace)
{
    std::string res = input;
    replaceAllInplace(res, search, replace);
    return res;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
