// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef STLUTILS_H
#define STLUTILS_H

std::string formatString(const char* fmt, ...);
std::string formatStringImpl(const char* fmt, va_list args);

// Splits a string on splitChar (ie: if you split "a, foo(c, d)" on ',' you will get [ "a", "foo(c", "d)" ])
std::vector<std::string> splitString(const std::string& value, char splitChar, int maxSplit=-1);

// Splits a string on splitChar but don't break scopes (ie: if you split "a, foo(c, d)" on ',' you will get [ "a", "foo(c, d)" ])
// Scopes takend into account: (), [], {}, "", <>
// If the split char is one of the scope delimiters, that scope will be ignored (e.g. if splitChar is '(' then () scopes will be ignored).
std::vector<std::string> splitStringWithScoping(const std::string& value, char splitChar);


template<typename ForwardIterator>
std::string joinStrings(ForwardIterator begin, ForwardIterator end, const std::string& delim);

inline std::string joinStrings(const std::vector<std::string>& strings, const std::string& delim) { return joinStrings(strings.begin(), strings.end(), delim); }
inline std::string joinStrings(const std::set<std::string>& strings, const std::string& delim) { return joinStrings(strings.begin(), strings.end(), delim); }

template<typename T>
std::string joinStrings(const std::vector<T>& objects, std::string (T::*member), const std::string& delim);

bool stringStartsWith(const std::string& str, const std::string& prefix);
bool stringEndsWith(const std::string& str, const std::string& end);

std::string toLower(const std::string& str);

/// Add a (possibly empty) prefix to name. e.g "A","B" -> "A::B" and "","B" -> "B"
std::string prefixScope(const std::string& prefix, const std::string& name);

/// Replace all "search" with "replace" in the input
inline std::string replaceAll(const std::string& input, const std::string& search, const std::string& replace);

/// Replace all "search" with "replace" in the input, inplace version.
void replaceAllInplace(std::string& inOut, const std::string& search, const std::string& replace);

// Small structure to manage the memory of an argv table.
// Warning: it implements *move* semantics for it's copy-ctor.
// An ArgcArgv object is no longer valid once a copy of it was made.
class ArgcArgv
{
    public:

        ArgcArgv();
        ArgcArgv(const std::string& str);
        ArgcArgv(const std::vector<std::string>& str);
        ArgcArgv(ArgcArgv&& rv);

        ~ArgcArgv();

        ArgcArgv& operator=(ArgcArgv&& rv);

        char** argv;
        int argc;

    private:

        // VS2012 doesn't support the '= delete' syntax so declare the copy ctor and
        // copy assign as private since this type is move-only.
        ArgcArgv& operator=(const ArgcArgv&);
        ArgcArgv(const ArgcArgv&);
};

#include "StlUtils.inl"

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
