// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0



RuntimeError::RuntimeError(const char* fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    m_message = formatStringImpl(fmt, args);
    va_end(args);
    m_errorMessage = buildLocatedMessageRelative(m_line, m_fileName, m_message);
}
RuntimeError::RuntimeError(const std::string& msg)
{
    m_errorMessage = msg;
}
FatalError::FatalError(const clang::Decl* decl, const char* fmt, ...)
{
    getLocation(decl, m_line, m_fileName);
    va_list args;
    va_start(args, fmt);
    m_message.append(formatStringImpl(fmt, args));
    va_end(args);
    m_errorMessage = buildLocatedMessage(m_line, m_fileName, m_message);
}

FatalError::FatalError(const clang::SourceManager& srcManager, clang::SourceLocation loc, const char* fmt, ...)
{
    getLocation(srcManager, loc, m_line, m_fileName);
    va_list args;
    va_start(args, fmt);
    m_message.append(formatStringImpl(fmt, args));
    va_end(args);
    m_errorMessage = buildLocatedMessage(m_line, m_fileName, m_message);
}

FatalError::FatalError(const char* fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    m_message = formatStringImpl(fmt, args);
    va_end(args);
    m_errorMessage = buildLocatedMessage(m_line, m_fileName, m_message);
}

FatalError::FatalError(unsigned int line, const std::string& filename, const char* fmt, ...)
    : m_line(line)
    , m_fileName(filename)
{
    va_list args;
    va_start(args, fmt);
    m_message = formatStringImpl(fmt, args);
    va_end(args);
    m_errorMessage = buildLocatedMessage(m_line, m_fileName, m_message);
}

FatalError::FatalError(const std::string& msg)
{
    m_errorMessage = msg;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
