// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef RUNTIME_ERROR_H
#define RUNTIME_ERROR_H

#include <clang/Basic/SourceLocation.h>

#include "StlUtils.h"

namespace clang { class Decl; }

/// Fill out the line and fileName parameters.
void getLocation(const clang::Decl* decl, unsigned int& line, std::string& fileName);
/// Fill out the line and fileName parameters.
void getLocation(const clang::SourceManager& srcManager, clang::SourceLocation loc, unsigned int& line, std::string& fileName);

/// Compose a standard message string from the given parts.
std::string buildLocatedMessage(unsigned int line, const std::string& fileName, const std::string& message);
std::string buildLocatedMessageRelative(unsigned int line, const std::string& fileName, const std::string& message);
/// Used to give exceptions different types.

// Implementation note: We want different sibling types of exception to express catch clauses.
// There seems to be no clean way to build a va_list to pass to a super-class and "using
// declarations" didn't seem to work for constructors with ellipsis. Hence use a template rather than inheritance.
class RuntimeError : public std::exception
{
    public:
        RuntimeError(const clang::Decl* decl, const char* fmt, ...);
        RuntimeError(const clang::SourceManager& srcManager, clang::SourceLocation loc, const char* fmt, ...);
        RuntimeError(unsigned int line, const std::string& filename, const char* fmt, ...);
        inline RuntimeError(const char* fmt, ...);
        inline RuntimeError(const std::string& msg);

        virtual ~RuntimeError() throw() { }
        virtual const char* what() const throw() { return m_errorMessage.c_str(); }

        unsigned int getLine() const { return m_line; }
        const char* getFileName() const { return m_fileName.c_str(); }
        const char* getMessage() const { return m_message.c_str(); }

    protected:
        // Complete message.
        std::string m_errorMessage;

        // Details.
        unsigned int m_line;
        std::string m_fileName;
        std::string m_message;
};

/// To be thrown when there is a reflection error.

/// This is for use when the application cannot do its job (e.g. on bad arguments) or there is an internal error.
/// The application ends with an error code.
class FatalError : public std::exception
{
public:
    inline FatalError(const clang::Decl* decl, const char* fmt, ...);
    inline FatalError(const clang::SourceManager& srcManager, clang::SourceLocation loc, const char* fmt, ...);
    inline FatalError(unsigned int line, const std::string& filename, const char* fmt, ...);
    inline FatalError(const char* fmt, ...);
    inline FatalError(const std::string& msg);

    virtual ~FatalError() throw() { }
    virtual const char* what() const throw() { return m_errorMessage.c_str(); }

    unsigned int getLine() const { return m_line; }
    const char* getFileName() const { return m_fileName.c_str(); }
    const char* getMessage() const { return m_message.c_str(); }
protected:
    std::string m_errorMessage;
    unsigned int m_line;
    std::string m_fileName;
    std::string m_message;
};
#include "RuntimeError.inl"

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
