// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include "pch.h"
PRAGMA_WARNING_PUSH
#include <llvm/Support/raw_ostream.h>
PRAGMA_WARNING_POP

#include "Database.h"
#include "RuntimeError.h"
#include "Logger.h"
#include "Filesystem.h"

void getLocation(const clang::Decl* decl, unsigned int& line, std::string& fileName)
{
    getLocation(decl->getASTContext().getSourceManager(), decl->getLocation(), line, fileName);
}

void getLocation(const clang::SourceManager& srcManager, clang::SourceLocation loc, unsigned int& line, std::string& fileName)
{
    if(loc.isValid())
    {
        clang::PresumedLoc presumeLoc = srcManager.getPresumedLoc( loc );
        line = presumeLoc.getLine();
        fileName = Filesystem::getCanonicalizedPath(presumeLoc.getFilename(), strlen(presumeLoc.getFilename()));
    }
}

std::string buildLocatedMessageRelative(unsigned int line, const std::string& fileName, const std::string& message)
{
    if ( fileName.empty() )
    {
        return message;
    }
    else
    {
        std::string fileNameRelative;
        if (!Filesystem::makePathRelativeToIncludes(fileName, fileNameRelative))
        {
            throw FatalError("Internal Error: Path %s could not be made relative to any include path", fileName.c_str());
        }
        return formatString("%s(%d): error PREBUILD: %s", fileNameRelative.c_str(), line, message.c_str());
    }
}
std::string buildLocatedMessage(unsigned int line, const std::string& fileName, const std::string& message)
{
    if ( fileName.empty() )
    {
        return message;
    }
    else
    {
        return formatString("%s(%d): error PREBUILD: %s", fileName.c_str(), line, message.c_str());
    }
}
RuntimeError::RuntimeError(const clang::Decl* decl, const char* fmt, ...)
{
    getLocation(decl, m_line, m_fileName);
    va_list args;
    va_start(args, fmt);
    m_message.append(formatStringImpl(fmt, args));
    va_end(args);
    m_errorMessage = buildLocatedMessageRelative(m_line, m_fileName, m_message);
}
RuntimeError::RuntimeError(const clang::SourceManager& srcManager, clang::SourceLocation loc, const char* fmt, ...)
{
    getLocation(srcManager, loc, m_line, m_fileName);
    va_list args;
    va_start(args, fmt);
    m_message.append(formatStringImpl(fmt, args));
    va_end(args);
    m_errorMessage = buildLocatedMessageRelative(m_line, m_fileName, m_message);
}
RuntimeError::RuntimeError(unsigned int line, const std::string& filename, const char* fmt, ...)
    : m_line(line)
    , m_fileName(filename)
{
    va_list args;
    va_start(args, fmt);
    m_message = formatStringImpl(fmt, args);
    va_end(args);
    m_errorMessage = buildLocatedMessageRelative(m_line, m_fileName, m_message);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
