// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef PROFILE_POINT_H
#define PROFILE_POINT_H

#ifdef _WIN32
    #include <windows.h>
    #include <winbase.h>
    #include <iomanip>
    #undef GetCurrentDirectory // remove annoying define from windows header
#else
    #include <time.h>
#endif


#define HIDDEN_PROFILE_POINT() static ProfilePoint pp ## __LINE__(0); pp ## __LINE__.profile()
#define PROFILE_POINT(NAME) static ProfilePoint pp##NAME(#NAME); pp##NAME.profile()

struct ProfilePoint
{
    static ProfilePoint* s_tail;
    ProfilePoint* m_prev;
    const char* m_name;

#ifdef _WIN32
    LARGE_INTEGER m_ticks;
    LONGLONG ticks()
    {
        return m_ticks.QuadPart;
    }
    void profile()
    {
        QueryPerformanceCounter(&m_ticks);
    }
    static double ticksPerSecond()
    {
        LARGE_INTEGER ticksPerSec;
        QueryPerformanceFrequency(&ticksPerSec);
        return double(ticksPerSec.QuadPart);
    }
#else
    clock_t m_ticks;
    clock_t ticks()
    {
        return m_ticks;
    }
    void profile()
    {
        m_ticks = clock();
    }
    static double ticksPerSecond()
    {
        return double(CLOCKS_PER_SEC);
    }
#endif

    ProfilePoint(const char* name)
    {
        m_name = name;
        m_prev = s_tail;
        s_tail = this;
    }

    static void print(const char* title)
    {
        const double ticksPerMSec = ticksPerSecond() / 1000.0;
        std::cerr << title << " (ticksPerMs = " << ticksPerMSec << ")\n";
        std::vector<ProfilePoint*> pps;
        for( ProfilePoint* pp = ProfilePoint::s_tail; pp->m_prev != NULL; pp = pp->m_prev )
        {
            pps.push_back(pp); // the list is backwards
        }

        for( int i = (int)pps.size()-1; i >= 0; i -= 1 )
        {
            ProfilePoint* pp = pps[i];
            if(pp->m_name)
                std::cerr << std::setw(20) << pp->m_name << " " << std::setw(16) << std::right << int(double(pp->ticks() - pp->m_prev->ticks()) / ticksPerMSec) << " ms" << std::endl;
        }
        int total = int(double(pps.front()->ticks() - pps.back()->ticks())/ ticksPerMSec);
        std::cerr << "----------------------------------------\n"
            << std::setw(20) << "Total" << std::setw(16) << std::right << total << " ms" << std::endl;
    }
};


#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
