// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef OPTIONAL_H
#define OPTIONAL_H

template<typename T>
class Optional
{
    public:

        Optional() : m_initialized(false), m_data() { }
        Optional(const Optional<T>& opt) : m_initialized(false), m_data() { *this = opt; }
        explicit Optional(const T& t) : m_initialized(false), m_data() { reset(t); }
        ~Optional() { reset(); }

        void reset()
        {
            m_initialized = false;
        }

        void reset(const T& t)
        {
            if(m_initialized)
                reset();

            m_initialized = true;
            m_data = t;
        }

        T& get() { assert(m_initialized); return m_data; }
        const T& get() const { assert(m_initialized); return m_data; }

        T& operator*() { return get(); }
        const T& operator*() const { return get(); }

        T* operator->() { return &get(); }
        const T* operator->() const { return &get(); }

        operator void*() const { return reinterpret_cast<void*>(m_initialized); }

        Optional<T>& operator=(const Optional<T>& rhs) { if(rhs) reset(rhs.get()); return *this; }

    private:

        bool m_initialized;
        T m_data;

        Optional<T>& operator=(const T&);
};

template<typename T>
std::istream& operator>>(std::istream& istr, Optional<T>& opt)
{
    opt.reset(T());
    return istr >> opt.get();
}


#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
