// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef LOGGER_H
#define LOGGER_H

#include <clang/Basic/SourceLocation.h>

namespace clang { class Decl; }

class Logger
{
    public:

        enum LevelType
        {
            LOG_ERROR,
            LOG_WARNING,
            LOG_INFO,
            LOG_DEBUG,
            LOG_NONE
        };

#ifndef NDEBUG
        Logger() : m_level(LOG_DEBUG) { }
#else
        Logger() : m_level(LOG_WARNING) { }
#endif

        const char* stringFromLevel(LevelType level);

        void setLevel(int level) { m_level = static_cast<LevelType>(level < LOG_DEBUG ? level : LOG_DEBUG); }
        void setLevel(LevelType level) { m_level = level; }

        void log(LevelType level, const char* fmt, ...);

        void error(const char* fmt, ...);
        void warning(const char* fmt, ...);
        void info(const char* fmt, ...);
        void debug(const char* fmt, ...);

        void error(const std::string& str) { error(str.c_str()); }
        void warning(const std::string& str) { warning(str.c_str()); }
        void info(const std::string& str) { info(str.c_str()); }
        void debug(const std::string& str) { debug(str.c_str()); }

        void error(const clang::Decl* decl, const char* fmt, ...);
        void warning(const clang::Decl* decl, const char* fmt, ...);
        void info(const clang::Decl* decl, const char* fmt, ...);
        void debug(const clang::Decl* decl, const char* fmt, ...);

        void error(const clang::SourceManager& mgr, clang::SourceLocation loc, const char* fmt, ...);
        void warning(const clang::SourceManager& mgr, clang::SourceLocation loc, const char* fmt, ...);
        void info(const clang::SourceManager& mgr, clang::SourceLocation loc, const char* fmt, ...);
        void debug(const clang::SourceManager& mgr, clang::SourceLocation loc, const char* fmt, ...);

        void error(const clang::SourceManager& mgr, clang::SourceLocation loc, const std::string& str) { error(mgr, loc, str.c_str()); }
        void warning(const clang::SourceManager& mgr, clang::SourceLocation loc, const std::string& str) { warning(mgr, loc, str.c_str()); }
        void info(const clang::SourceManager& mgr, clang::SourceLocation loc, const std::string& str) { info(mgr, loc, str.c_str()); }
        void debug(const clang::SourceManager& mgr, clang::SourceLocation loc, const std::string& str) { debug(mgr, loc, str.c_str()); }

        // Named to avoid incorrect overloads.
        void warningWithoutDatabase(unsigned int line, const char* fileName, const char* fmt, ...);
        void errorWithoutDatabase(unsigned int line, const char* fileName, const char* fmt, ...);

        const std::string& loggedMessages() const { return m_loggedMessages; }
        const std::string& loggedErrors() const { return m_loggedErrors; }
        const std::string& loggedWarnings() const { return m_loggedWarnings; }

        /// Since logged errors are written into separate files, you should clear them after they've been accessed.
        void clearLoggedErrors() { m_loggedErrors.clear(); }
        void clearLoggedWarnings() { m_loggedWarnings.clear(); }

    private:

        void setTextColor(LevelType c);
        void logImpl(LevelType level, const char* fmt, va_list arg);
        void logImpl(LevelType level, const clang::SourceManager& mgr, const clang::SourceLocation loc, const char* fmt, va_list arg);
        void logImpl(LevelType level, unsigned int line, const char* fileName, const char* fmt, va_list arg);

        std::string emitLineDirective(unsigned int line, const char* fileName);

        LevelType m_level;
        std::string m_loggedMessages;
        std::string m_loggedErrors;
        std::string m_loggedWarnings;
};

extern Logger hkLog;

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
