// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef LLVM_HAVOK_UTILS_H
#define LLVM_HAVOK_UTILS_H

#include "Common/Base/Fwd/hksal.h"

#define HK_NULL 0
#define HK_DECLARE_PLACEMENT_ALLOCATOR(...)
#define HK_DECLARE_CLASS(...)
#define HK_REFLECT_AS_STRING_UTF8_MUTABLE(...)
#define HK_REFLECT_AS_STRING_UTF8_IMMUTABLE(...)
#define HK_REFLECT_AS_ARRAY(...)
#define HK_RECORD_ATTR(...)
#define HK_CALL
#define HK_EXPORT_COMMON
#define HK_INLINE inline
#define HK_ALWAYS_INLINE inline
#define HK_ASSERT_NO_MSG(ID, EXPR) assert(EXPR)
#define HK_BREAKPOINT(ID) assert(0)
#define HK_OVERRIDE
#define hkLosslessCast static_cast
#define HK_WARN(...)
#define HK_CONSTEXPR
#define HK_NOEXCEPT

#define HKBASE_HKBASE_H // Avoid including hkBase.h

#ifdef _DEBUG
    #ifndef HK_DEBUG
        #define HK_DEBUG
    #endif
#endif

class hkMemoryAllocator;
class hkStringBuf;
namespace hkReflect
{
    class Var;
}

typedef unsigned char hkUint8;

struct HK_EXPORT_COMMON hkResult
{
    HK_DECLARE_CLASS(hkResult, New, Reflect, Pod);
    HK_RECORD_ATTR(hk::IncludeInMgd(false));
    //+hk.MemoryTracker(ignore=True)

    HK_ALWAYS_INLINE bool isSuccess() const
    {
        return m_code >= 0;
    }

    HK_ALWAYS_INLINE bool isFailure() const
    {
        return m_code < 0;
    }

    int m_code;
};

#define HK_SUCCESS hkResult{0}
#define HK_FAILURE hkResult{-1}

struct hkBoolOperator
{
    typedef bool BoolType;
    static inline BoolType cast(bool v) { return v; }
};

template<typename, typename>
struct hkFlags
{
    inline hkFlags()    {}
    inline hkFlags(int s)   { m_storage = s; }
    inline bool anyIsSet( int mask ) const { return (m_storage & mask) != 0; }
    inline void orWith( int mask ) { m_storage = m_storage | mask; }

    int m_storage;
};

typedef bool hkBool;

typedef float  hkFloat32;
typedef float  hkReal;
typedef double hkDouble64;
typedef signed char     hkChar;
typedef signed char     hkInt8;
typedef signed short    hkInt16;
typedef signed int      hkInt32;
typedef unsigned char   hkUchar;
typedef unsigned char   hkUint8;
typedef unsigned short  hkUint16;
typedef unsigned int    hkUint32;
typedef unsigned long long hkUint64;
typedef long long hkInt64;
typedef unsigned long hkUlong;
typedef signed long hkLong;

inline hkUint32 computeFNV1Hash32(const char*, int)
{
    assert(false);
    return 0;
}

#define HK_COMPILE_TIME_ASSERT(x)
#define HK_EXCLUDE_ARRAY_VIEW_REFLECTION
#define HK_DETAIL_DIAG_MSVC_PUSH()
#define HK_DETAIL_DIAG_MSVC_OFF(x)
#define HK_DETAIL_DIAG_MSVC_POP()

#include <Common/Base/Types/hkTrait.h>
#include <Common/Base/Container/ArrayView/hkArrayView.h>
#include <Common/Base/Container/StringView/hkStringView.h>

bool operator==(const std::string& str, const hkStringView& view);
bool operator==(const hkStringView& view, const std::string& str);

namespace hkString
{
    char toLower(char c);

    inline int strLen(const char* str)  { return (int)strlen(str); }

    int strCmp(const char* a, const char* b);

    int strNcmp(const char* a, const char* b, int n);

    int strNcasecmp(const char* a, const char* b, int n);

    int atoi(const char* in, int base = 10);

    float atof(const char* in);

    void memSet(void* dst, const int c, int nBytes);

    void memCpy(void* dst, const void* src, int nBytes);

    void strNcpy(char *dst, int dstBytes, const char *src, int n);

    const char* strChr(const char* haystack, int needle);
}

template<typename T>
class hkArray
{
public:
    hkArray() {}

    int getSize() const { return (int)m_vec.size(); }

    void setSize(int size) { m_vec.resize(size); }

    bool isEmpty() const { return m_vec.empty(); }

    T& operator[](int i) { return m_vec[i]; }

    const T& operator[](int i) const { return m_vec[i]; }

    void pushBack(const T& e) { m_vec.push_back(e); }

    void append(const T* a, int numElements) { m_vec.insert(m_vec.end(), a, a + numElements); }

    T& back() { return m_vec.back(); }

    hkResult reserve(int size)
    {
        m_vec.reserve(size * sizeof(T));
        return HK_SUCCESS;
    }

    T& expandOne()
    {
        m_vec.resize(m_vec.size() + 1);
        return m_vec.back();
    }

    typedef T* iterator;
    typedef const T* const_iterator;

    iterator begin() { return m_vec.empty() ? 0 : &m_vec.front(); }
    iterator end() { return m_vec.empty() ? 0 : (&m_vec.front() + m_vec.size()); }
    const_iterator begin() const { return m_vec.empty() ? 0 : &m_vec.front(); }
    const_iterator end() const { return m_vec.empty() ? 0 : (&m_vec.front() + m_vec.size()); }

    template<typename U>
    operator hkArrayView<U>() const
    {
        return hkArrayView<U>(begin(), static_cast<hkUlong>(m_vec.size()));
    }

    void removeAtAndCopy(int index)
    {
        m_vec.erase(m_vec.begin() + index);
    }
private:
    std::vector<T> m_vec;
};

template<typename T, int N>
class hkInplaceArray : public hkArray<T> {};

#define HKBASE_HKSTRINGBUF_H
class hkStringBuf
{
public:
    hkStringBuf();

    hkStringBuf(const hkStringView& s);

    const char* cString() const;

    int getLength() const;

    void set(const char* s, int len = -1);

    void printf(const char* format, ...);

    void appendPrintf(const char* format, ...);

    void vprintf(const char* format, va_list args);

    void append(const char* s, int len = -1);

    void chompEnd(int n);

    void clear();

    operator hkStringView() const;

    operator std::string() const { return m_str; }

private:
    std::string m_str;
};

#define HKBASE_HKSTRINGPTR_H
class hkStringPtr
{
public:
    hkStringPtr();

    hkStringPtr(const char*);

    hkStringPtr(const hkStringPtr&);

    hkStringPtr(hkStringPtr&&);

    ~hkStringPtr();

    const char* cString() const;

    operator hkStringView() const;

    operator std::string() const { return m_str; }

    void operator = (hkStringPtr&&);

    void operator = (const hkStringPtr&);

private:
    // Cannot use std::string since std::string uses SVO, which prevents taking a hkStringView and moving the
    // hkStringPtr object later.
    char* m_str;
};

namespace hkMath
{
    template <typename T1, typename T2>
    inline static T1 min2(T1 x, T2 y)
    {
        return x < (T1)y ? x : (T1)y;
    }
}

PRAGMA_WARNING_PUSH

#include "Common/Base/Reflect/Attributes/hkAttributeParser.h"
#include "Common/Base/Reflect/ReflectFile/hkReflectFileParser.h"

PRAGMA_WARNING_POP

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
