// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include "pch.h"
#include "HavokUtils.h"

#define HK_OPTION_PARSER_CONSOLE_WIDTH 150

#ifdef HK_COMPILER_RAZZLE
#define vsnprintf(...) _vsnprintf(__VA_ARGS__)
#endif

namespace hkString
{
    char toLower(char c)
    {
        return char(tolower(c));
    }

    int strCmp(const char* a, const char* b)
    {
        return strcmp(a, b);
    }

    int strNcmp(const char* a, const char* b, int n)
    {
        return strncmp(a, b, n);
    }

    int strNcasecmp(const char* a, const char* b, int n)
    {
        int i = 0;
        while ( ( a[i] != '\0' || b[i] != '\0' ) && i < n )
        {
            if ( a[i] == '\0' )
            {
                return -1;
            }
            else if ( b[i] == '\0' )
            {
                return 1;
            }

            const char lowerA = toLower( a[i] );
            const char lowerB = toLower( b[i] );
            if ( lowerA < lowerB )
            {
                return -1;
            }
            else if ( lowerA > lowerB )
            {
                return 1;
            }
            ++i;
        }

        return 0;
    }

    int atoi(const char* in, int base)
    {
        return strtol(in, HK_NULL, base);
    }

    float atof(const char* in)
    {
#ifdef HK_COMPILER_RAZZLE
        return static_cast<float>(::atof(in));
#else
        return strtof(in, HK_NULL);
#endif
    }

    void memSet(void* dst, const int c, int nBytes)
    {
        memset(dst, c, nBytes);
    }

    void memCpy(void* dst, const void* src, int nBytes)
    {
        memcpy(dst, src, nBytes);
    }

    int indexOf(const char* str, char c)
    {
        const char* res = strchr(str, c);
        return int(res ? (res - str) : -1);
    }

    void strNcpy(char *dst, int, const char *src, int n)
    {
        strncpy(dst, src, n);
    }

    inline const char* strChr(const char* haystack, int needle)
    {
        return strchr(haystack, needle);
    }
}

hkStringBuf::hkStringBuf()
{
}

hkStringBuf::hkStringBuf(const hkStringView& s)
    : m_str(s.data(), s.getSize())
{
}

const char* hkStringBuf::cString() const
{
    return m_str.c_str();
}

int hkStringBuf::getLength() const
{
    return (int)m_str.size();
}

void hkStringBuf::set(const char* s, int len)
{
    m_str.assign(s, len >= 0 ? len : strlen(s));
}

void hkStringBuf::append(const char* s, int len)
{
    m_str += len >=0 ? std::string(s, len) : std::string(s);
}

void hkStringBuf::chompEnd(int n)
{
    m_str = m_str.substr(0, m_str.length()-n);
}

void hkStringBuf::printf(const char* format, ...)
{
    va_list va;
    va_start(va, format);
    vprintf(format, va);
    va_end(va);
}

void hkStringBuf::appendPrintf(const char* format, ...)
{
    char errorMsgBuffer[HK_OPTION_PARSER_CONSOLE_WIDTH];
    va_list va;
    va_start(va, format);
    vsnprintf(errorMsgBuffer, HK_OPTION_PARSER_CONSOLE_WIDTH, format, va);
    va_end(va);
    m_str += errorMsgBuffer;
}

void hkStringBuf::vprintf(const char* format, va_list va)
{
    char errorMsgBuffer[HK_OPTION_PARSER_CONSOLE_WIDTH];
    vsnprintf(errorMsgBuffer, HK_OPTION_PARSER_CONSOLE_WIDTH, format, va);
    m_str = errorMsgBuffer;
}

hkStringBuf::operator hkStringView() const
{
    return hkStringView(&m_str[0], (int)m_str.length());
}

void hkStringBuf::clear()
{
    m_str.clear();
}

hkStringPtr::hkStringPtr()
    : m_str(nullptr)
{

}

hkStringPtr::hkStringPtr(const char* cStr)
    : m_str(nullptr)
{
    if (cStr)
    {
        size_t len = strlen(cStr);
        m_str = new char[len + 1];
        memcpy(m_str, cStr, len + 1);
    }
}

hkStringPtr::hkStringPtr(const hkStringPtr& rhs)
    : m_str(nullptr)
{
    if (rhs.m_str)
    {
        size_t len = strlen(rhs.m_str);
        m_str = new char[len + 1];
        memcpy(m_str, rhs.m_str, len + 1);
    }
}

hkStringPtr::hkStringPtr(hkStringPtr&& rhs)
    : m_str(rhs.m_str)
{
    rhs.m_str = nullptr;
}

void hkStringPtr::operator = (hkStringPtr&& rhs)
{
    std::swap(this->m_str, rhs.m_str);
}

void hkStringPtr::operator = (const hkStringPtr& rhs)
{
    if (m_str)
    {
        delete[] m_str;
        m_str = nullptr;
    }
    if (rhs.m_str)
    {
        size_t len = strlen(rhs.m_str);
        m_str = new char[len + 1];
        memcpy(m_str, rhs.m_str, len + 1);
    }
}

hkStringPtr::~hkStringPtr()
{
    delete[] m_str;
}

const char* hkStringPtr::cString() const
{
    return m_str;
}

hkStringPtr::operator hkStringView() const
{
    return m_str ? hkStringView() : hkStringView(&m_str[0], static_cast<hkUlong>(strlen(m_str)));
}

bool operator==(const std::string& str, const hkStringView& view)
{
    return (view == str);
}

bool operator==(const hkStringView& view, const std::string& str)
{
    return static_cast<unsigned>(view.getSize()) == str.length() && strncmp(str.c_str(), view.begin(), view.getSize()) == 0;
}

template <typename TYPE>
inline const TYPE* hkAddByteOffsetConst(const TYPE* base, hkLong offset)
{
    return reinterpret_cast<const TYPE*>(reinterpret_cast<hkUlong>(base)+offset);
}

PRAGMA_WARNING_PUSH

struct hkMemoryRouter
{
    static hkMemoryRouter getInstance() { assert(false); return hkMemoryRouter(); }
    hkMemoryAllocator& heap() { assert(false); return *reinterpret_cast<hkMemoryAllocator*>(0); }
    void* easyAlloc( hkMemoryAllocator& b, int nbytes ) { assert(false); return 0; }
};

namespace hkMemUtil
{
    inline int memCmp(const void* a, const void* b, int n)
    {
        return memcmp(a, b, n);
    }

    inline void* memCpy(void* dst, const void* src, size_t size)
    {
        return memcpy(dst, src, size);
    }
}

namespace hkReflect
{
    class Var
    {
        public:
            template<typename T> T* dynCast() const { assert(false); return 0; }
    };

    namespace Detail { class StringImpl {}; }
    typedef const char* StringValue;

    class StringType {};
}

hkMemoryAllocator* HK_CALL hkMemHeapAllocator() { return nullptr; }

#define HK_RETURN_IF_FAILED( hExpr, /* [const char* fmt, [fmtArgs...]]*/ ...) \
    do { hkResult _hr = hExpr; if( _hr.isFailure() ) { return _hr; } } while(0, 0)

#include "Common/Base/Container/StringView/hkStringView.cpp"
#include "Common/Base/Reflect/Attributes/hkAttributeParser.cpp"
#include "Common/Base/Reflect/ReflectFile/hkSimpleToken.cpp"
#include "Common/Base/Reflect/ReflectFile/hkSimpleTokenizer.cpp"
#include "Common/Base/Reflect/ReflectFile/hkReflectFileParser.cpp"

PRAGMA_WARNING_POP

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
