// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef ELEMENT_UTILS_H
#define ELEMENT_UTILS_H

PRAGMA_WARNING_PUSH
#include <clang/AST/Attr.h>
#include <clang/AST/Type.h>
#include <clang/AST/DeclBase.h>
#include <clang/AST/DeclTemplate.h>
PRAGMA_WARNING_POP

class Database;

const clang::CXXRecordDecl* getCXXRecordFrom(const clang::Type* type);
inline const clang::CXXRecordDecl* getCXXRecordFrom(const clang::QualType& type)
{
    return getCXXRecordFrom(type.getTypePtr());
}

void checkIsDefinition(const clang::CXXRecordDecl* decl);

const clang::TemplateParameterList* getTemplateParams(const clang::Decl* decl);

// Returns true if the decl or one of its decl contexts is a pure template or a partial specialization.
bool hasTemplateParamsRecursive(const clang::Decl* decl);

// Returns true if the decl is a template, a specialization or is contained in one of them.
bool isTemplateRecursive(const clang::Decl* decl);

std::string getTemplateParametersString(const clang::Decl* tplDecl);
std::string getTemplateParametersString(const clang::Decl* tplDecl, std::vector<std::string>& tplParams, bool addKeyword);
std::string getTemplateParametersStringRecursive(const clang::Decl* decl);

bool needsBypassConstructor(const Database& db, const clang::CXXRecordDecl* recDecl, std::string& reason);
bool hasBypassConstructor(const clang::CXXRecordDecl* recDecl);
bool hasBypassAndPublicDefaultConstructor(clang::QualType type);
inline bool hasBypassConstructor(clang::QualType type)
{
    if (auto rec = getCXXRecordFrom(type.getTypePtr()))
    {
        return hasBypassConstructor(rec);
    }
    return false;
}

bool isBypassConstructor(const clang::CXXConstructorDecl* ctorDecl);
bool hasDtor(const clang::CXXRecordDecl* recDecl);
bool isInterfaceRecord(const clang::CXXRecordDecl* decl);

clang::QualType resolveTypedefType(clang::QualType type);
clang::QualType resolveElaboratedType(clang::QualType elabType);

// Resolves typedef and elaborated decorators.
clang::QualType resolveType(clang::QualType type);

std::string getStaticStringType(const std::string& str);
std::string pyNameFromCxxName(const std::string& cxxName);

bool hasFields(const clang::CXXRecordDecl* decl);
const clang::CXXMethodDecl* hasAfterReflectNew( const clang::CXXRecordDecl* recDecl );

std::pair<std::string, std::string> getNamespaceBlock(const clang::Decl* decl);
std::string getNamespaceString(const clang::Decl* decl);

const clang::CXXRecordDecl* getCXXRecordFromTemplate(const clang::ClassTemplateDecl* tplDecl);

inline const clang::CXXRecordDecl* getCXXRecordFromTemplate(const clang::ClassTemplateSpecializationDecl* tplDecl)
{
    return tplDecl;
}

/// This function performs as isA style check, it tests definitionBeingTested to understand if the type
/// defined by it represents a type derived from (or the same type as) the type defined by parentDefinition.
/// This function only explores the main parent chain (it doesn't consider secondary parents).
/// This function only accepts definitions, if the provided declarations are not definitions, the process will crash.
bool definitionIsA(const clang::CXXRecordDecl* parentDefinition, const clang::CXXRecordDecl* definitionBeingTested);

inline const clang::ClassTemplateDecl* getTemplateDecl(const clang::CXXRecordDecl* decl)
{
    if (const clang::ClassTemplateSpecializationDecl* specDecl = clang::dyn_cast<clang::ClassTemplateSpecializationDecl>(decl))
    {
        return specDecl->getSpecializedTemplate();
    }
    else
    {
        return decl->getDescribedClassTemplate();
    }
}

inline const clang::ClassTemplateDecl* getTemplateDecl(const clang::Decl* decl)
{
    if(auto tplDecl = clang::dyn_cast<clang::ClassTemplateDecl>(decl))
    {
        return tplDecl;
    }
    else if (auto recDecl = clang::dyn_cast<clang::CXXRecordDecl>(decl))
    {
        return getTemplateDecl(recDecl);
    }

    return 0;
}

// Get the type of decl. Will throw an error if the decl is not a TypeDecl, a field or a property.
clang::QualType getTypeFrom(const Database& db, const clang::Decl* decl);

// Get the field type if the decl is a field or a property, null otherwise.
clang::QualType getFieldTypeFrom(const Database& db, const clang::Decl* decl);

// Get the decl from the type if it has one, null otherwise.
const clang::TypeDecl* getDeclFrom(clang::QualType type);

// Get the TypeDecl from the type corresponding to the passed decl (equivalent to getDeclFrom(getTypeFrom(decl))).
const clang::TypeDecl* getTypeDeclFrom(const Database& db, const clang::Decl* decl);

inline std::string fieldNameWithoutPrefix(const std::string& prefix, const std::string& fieldName)
{
    if(fieldName.find(prefix) == 0)
        return fieldName.substr(prefix.size(), std::string::npos);
    return fieldName;
}

enum SpecialMethod
{
    DEF_CONSTRUCTOR,
    COPY_CONSTRUCTOR,
    DESTRUCTOR,
    COPY_ASSIGNMENT
};

// Must test if the searched special method is trivial in the given Record (e.g. hasTrivialDefaultConstructor(), hasTrivialDestructor()).
typedef bool (clang::CXXRecordDecl::*DeclHasTrivialMethod)() const;
// Must return the current special method in the given Record, if existing.
typedef const clang::CXXMethodDecl* (*FindMethodFunc)(const clang::CXXRecordDecl*);

struct SpecialMethodsData
{
    const char* optional;
    DeclHasTrivialMethod declHasTrivialMethod;
    FindMethodFunc findMethodFunc;
};

const SpecialMethodsData& getSpecialMethodsData(SpecialMethod method);

enum MethodType
{
    METHOD_TRIVIAL,
    METHOD_IMPLICIT,
    METHOD_UNKNOWN,
    METHOD_EXPLICIT,
    METHOD_UNAVAILABLE,
    _METHOD_COUNT
};

MethodType getMethodType(const Database& db, const clang::CXXRecordDecl* recDecl, SpecialMethod specialMethod);

template <typename T>
const T* findMemberDecl(const clang::CXXRecordDecl* recDecl, const std::string& name)
{
    for (auto it = clang::CXXRecordDecl::specific_decl_iterator<T>(recDecl->decls_begin());
        it != clang::CXXRecordDecl::specific_decl_iterator<T>(recDecl->decls_end()); ++it)
    {
        if (it->getNameAsString() == name)
        {
            return *it;
        }
    }
    return nullptr;
}

// Returns a nested type decl; if the name corresponds to a ClassTemplateDecl, returns the associated Record.
const clang::TypeDecl* findMemberTypeDecl(const clang::CXXRecordDecl* recDecl, const std::string& name);

// Returns the definition for the dependent name identified by (scope, id).
// scopeAsType will be set the type corresponding to the scope, if any.
const clang::TypeDecl* getDependentTypeDefinition(const clang::NestedNameSpecifier* scope, const clang::IdentifierInfo* id);
const clang::TypeDecl* getDependentTypeDefinition(const clang::NestedNameSpecifier* scope, const clang::IdentifierInfo* id, clang::QualType& scopeAsType);

// Returns decl cast as a CXXRecordDecl if it is a property placeholder, null otherwise.
const clang::CXXRecordDecl* isPropertyDecl(const clang::Decl* decl);

// Returns the name of the property (decl must be a property decl).
std::string getPropertyDeclName(const clang::CXXRecordDecl* decl);

// Name, get method, set method
typedef std::tuple<std::string, const clang::CXXMethodDecl*, const clang::CXXMethodDecl*> PropertyData;
PropertyData getPropertyData(const Database& db, const clang::CXXRecordDecl* propertyDecl);

/// This returns a typedefDecl at the same location as the HK_DECLARE_CLASS or HK_DECLARE_REFLECTION macro, if either exist.
const clang::TypedefDecl* getHkDeclareClassDecl( const clang::CXXRecordDecl* recDecl );

std::string getAttrName(const clang::AnnotateAttr* annotation, const clang::SourceManager& sm);
std::string getAttrNameOrEmpty(const clang::AnnotateAttr* annotation, const clang::SourceManager& sm);

bool isAbstract(const clang::CXXRecordDecl* recDecl);

bool isPubliclyAccessible(const clang::Decl* decl);

std::string getAggregateTypeFor(const std::string& cxxName, bool isTemplate);

#endif // ELEMENT_UTILS_H

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
