// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
template<typename ValueType>
ValueType Database::getAttributeValue(const clang::AnnotateAttr* attr) const
{
    return Attribute(*this, attr).as<ValueType>();
}

template<typename ValueType>
ValueType Database::getAttributeValue(const clang::Decl* decl, const std::string& attrName, ValueType notFoundValue) const
{
    const std::vector<ValueType>& vals = getAllAttributesValues<ValueType>(decl, attrName);

    if(vals.empty())
        return notFoundValue;
    else if(vals.size() == 1)
        return vals.front();
    else
        throw RuntimeError(decl, "Attribute '%s' is specified multiple times.", attrName.c_str());
}

template<typename ValueType>
ValueType Database::getAttributeValueInHierarchy(const clang::Decl* decl, const std::string& attrName, ValueType notFoundValue) const
{
    if(const clang::AnnotateAttr* attr = getAttributeInHierarchy(decl, attrName))
        return getAttributeValue<ValueType>(attr);
    else
        return notFoundValue;
}


template<typename ValueType>
std::vector<ValueType> Database::getAllAttributesValues(const clang::Decl* decl, const std::string& attrName) const
{
    const std::vector<const clang::AnnotateAttr*>& attrs = getAllAttributes(decl, attrName);
    std::vector<ValueType> vals;

    for(std::vector<const clang::AnnotateAttr*>::const_iterator it = attrs.begin(); it != attrs.end(); ++it)
    {
        vals.push_back(getAttributeValue<ValueType>(*it));
    }

    return vals;
}

inline std::string Database::getReflectedTypeAddress(const std::string& typeName, bool tracker) const
{
    return formatString("%s( %s )", tracker ? "HK_TRACKER_GET_HANDLE" : "HK_REFLECT_GET_TYPE", typeName.c_str());
}

inline bool Database::isReflected(const clang::QualType type) const
{
    return isReflected(type.getTypePtr());
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
