// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef STATIC_ATTRIBUTE_H
#define STATIC_ATTRIBUTE_H


PRAGMA_WARNING_PUSH
#include <clang/AST/Decl.h>
#include <clang/AST/Attr.h>
PRAGMA_WARNING_POP

#include "utils/Optional.h"
#include "utils/RuntimeError.h"
#include "utils/HavokUtils.h"

class Database;
class Attribute;

class AttributeDecl
{
    public:
        AttributeDecl(const Database& db, const clang::CXXRecordDecl* rec)
            : m_db(db), m_recDecl(rec), m_parsed(false) {}

        struct Field
        {
            Field (const hkAttrData::FieldDecl& decl, const std::vector<std::string>& default_)
                : m_decl(decl), m_default(default_) {}
            hkAttrData::FieldDecl m_decl;
            std::vector<std::string> m_default;
        };

        const clang::CXXRecordDecl* getRec() const { return m_recDecl; }
        const std::vector<Field>& getFields() const;

    private:
        void parse(const clang::CXXRecordDecl* currentDecl) const;
        void operator=(const AttributeDecl&);

        const Database& m_db;
        const clang::CXXRecordDecl* m_recDecl;
        mutable bool m_parsed;
        mutable std::vector<Field> m_fields;
        mutable std::vector<std::string> m_fieldNames;
};

// todo.ntm no support for more than one array per attribute
class AttributeValue
{
    public:

        AttributeValue() : attribute(nullptr) {}
        explicit AttributeValue(const Attribute* attr, const std::string& val)
            : attribute(attr), value(val) {}

        operator const std::string&() const { return value; }

        template<typename ValueType>
        ValueType as() const;

        const Attribute* attribute;
        std::string value;
};

template<> inline std::string AttributeValue::as<std::string>() const { return value; }

class Attribute
{
    public:

        Attribute() : m_db(nullptr), m_srcMgr(nullptr), m_hasValidation(false) { }
        Attribute(const Database& db, const clang::AnnotateAttr* attrVal);
        Attribute(const Database& db, const std::string& attrString, clang::SourceLocation location);

        Optional<AttributeValue> operator[](const std::string& name) const;
        Optional<AttributeValue> operator[](std::size_t idx) const { assert(idx < m_arrayValues.size()); return Optional<AttributeValue>(AttributeValue(this, m_arrayValues[idx])); }

        typedef std::map<std::string, std::string>::const_iterator NamedValuesIterator;
        NamedValuesIterator namedBegin() const { return m_namedValues.begin(); }
        NamedValuesIterator namedEnd() const { return m_namedValues.end(); }

        typedef std::vector<std::string>::const_iterator PosValuesIterator;
        PosValuesIterator posBegin() const { return m_arrayValues.begin(); }
        PosValuesIterator posEnd() const { return m_arrayValues.end(); }

        /// Returns the field's value if it's defined or an empty string otherwise
        std::string get(const std::string& name) const;

        /// Returns the field's value if it's defined or ifNotFound otherwise
        std::string get(const std::string& name, const std::string& ifNotFound) const;

        /// Returns the i-th positional argument if it's defined or an empty string otherwise
        std::string get(unsigned int i) const;

        /// Returns the number of positional arguments.
        int getNumPosValues() const { return (int)m_arrayValues.size(); }

        /// Returns all positional arguments in a string. If there is more than one argument,
        /// or forceBraces is true, the arguments are concatenated by commas and enclosed by braces.
        std::string getPosValuesString(bool forceBraces = false) const;

        template<typename ValueType>
        ValueType as() const
        {
            assert(m_namedValues.size() == 1);
            assert(m_arrayValues.empty());
            return AttributeValue(this, m_namedValues.begin()->second).as<ValueType>();
        }

        const std::string& getFullAttr() const { return m_fullAttr; }
        const std::string& getAttrName() const { return m_attrName; }
        const Database* getDb() const { return m_db; }
        const clang::SourceManager& getSrcMgr() const { assert(m_srcMgr); return *m_srcMgr; }
        clang::SourceLocation getLocation() const { return m_location; }

        bool hasValidation() const { return m_hasValidation; }

    private:
        void parse();

        const Database* m_db;
        const clang::SourceManager* m_srcMgr;
        clang::SourceLocation m_location;
        std::map<std::string, std::string> m_namedValues;
        std::vector<std::string> m_arrayValues;
        std::string m_fullAttr;
        std::string m_attrName;
        bool m_hasValidation;
};

template<typename ValueType>
ValueType AttributeValue::as() const
{
    ValueType val= ValueType();
    std::istringstream istr(value);
    istr.setf(std::ios_base::boolalpha);
    if(!(istr >> val))
        throw RuntimeError(attribute->getSrcMgr(), attribute->getLocation(),
        "Could not parse the value '%s'.", value.c_str());

    return val;
}

template<> inline Attribute Attribute::as<Attribute>() const { return *this; }
template<> inline Optional<Attribute> Attribute::as< Optional<Attribute> >() const { return Optional<Attribute>(*this); }

template<>
inline Optional<std::string> Attribute::as< Optional<std::string> >() const
{
    assert(m_namedValues.size() == 1);
    assert(m_arrayValues.empty());
    return Optional<std::string>(m_namedValues.begin()->second);
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
