// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef ATTRIBUTE_REGISTRY_H
#define ATTRIBUTE_REGISTRY_H

#define CONCAT(a, b) CONCAT_I(a, b)
#define CONCAT_I(a, b) a ## b
#define REGISTER_ATTRIBUTE(f) static const AttributeRegistry CONCAT(registry, __LINE__) (#f, &f)

class Database;
class TypeOut;

struct AttributeRegistry
{
    /// Generates runtime data for the attribute and adds it to the provided TypeOut.
    /// Returns (attribute symbol, attribute type).
    typedef std::tuple<std::string, std::string, std::string> (*AttributeFunction)(
        const Attribute& attribute,
        const Database& db,
        const clang::NamedDecl* decl,   
        TypeOut& typeOut,               
        const std::string& sectionScope 
        );

    AttributeRegistry(const char* name, AttributeFunction fun) { setAttribute(name, fun); }

    typedef std::map<std::string, AttributeFunction> AttributeMap;

    static AttributeFunction getAttribute(const std::string& name) { if(AttributeFunction f = getAttributeMap()[name]) return f; else return getAttributeMap()["defaultHandler"]; }
    static void setAttribute(const char* name, AttributeFunction fun) { getAttributeMap()[name] = fun; }
    static AttributeMap& getAttributeMap() { static AttributeMap attributes; return attributes; }
};

struct Presets
{
    hkBool strict;
    std::string valueType;
    std::string type;

    struct Val
    {
        std::string name;
        std::string value;
        std::vector<Attribute> attribs;
    };

    std::vector<Val> values;
};


struct PresetsData
{
    std::string strict;
    std::string type;
    int count;
    std::string names;
    std::string values;
    bool hasAttribs;
    std::string attribArrays;
};

PresetsData generatePresetsData(const Attribute& attr, const Database& db, const clang::NamedDecl* decl, TypeOut& typeOut, const std::string& sectionScope);

PresetsData generatePresetsData(const Presets& presets, const Database& db, const clang::NamedDecl* decl, TypeOut& typeOut, const std::string& sectionScope);

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
