// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef RAW_DUMP_H
#define RAW_DUMP_H

PRAGMA_WARNING_PUSH
    #include "clang/AST/AST.h"
    #include "clang/Sema/SemaConsumer.h"
    #include "clang/Frontend/CompilerInstance.h"
    #include "llvm/Support/ManagedStatic.h"
PRAGMA_WARNING_POP

////////////////////////////////////////////////////////////////////////////
////////////////////// TEMPORARY ATTRIBUTES HANDLER ////////////////////////
/////// TO BE REMOVED WHEN WE USE THE PROPER SYNTAX ALL OVER THE SDK ///////
////////////////////////////////////////////////////////////////////////////

PRAGMA_WARNING_PUSH
    #include <clang/Lex/Preprocessor.h>
PRAGMA_WARNING_POP

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

namespace Havok
{
    using namespace clang;

    class RawDumpDocCommentHandler : public CommentHandler
    {
        public:
            RawDumpDocCommentHandler(const SourceManager& sourceManager, const std::vector<std::string>& inputFileNames);
            virtual bool HandleComment(clang::Preprocessor& PP, clang::SourceRange Comment);

        private:
            RawDumpDocCommentHandler& operator=(const RawDumpDocCommentHandler& other);
            bool isInteresting(clang::FileID fid);

            const SourceManager& m_sourceManager;

            /// A cache for the isInteresting function. This map maps known
            /// FileID's to a boolean value which indicates whether the file is
            /// interesting or not. If a FileID doesn't exist in this cache, the
            /// isInteresting function needs to compute whether the file is
            /// interesting from scratch.
            std::map<clang::FileID, bool> m_interesting;

            std::vector<std::string> m_inputFileNames;
    };
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////// TEMPORARY ATTRIBUTES HANDLER ////////////////////////
    /////// TO BE REMOVED WHEN WE USE THE PROPER SYNTAX ALL OVER THE SDK ///////
    ////////////////////////////////////////////////////////////////////////////

    class RawDumpAttributeHandler : public CommentHandler
    {
        public:
            RawDumpAttributeHandler(const SourceManager& sourceManager);
            virtual bool HandleComment(clang::Preprocessor& PP, clang::SourceRange Comment);
            virtual ~RawDumpAttributeHandler();
        protected:
            const SourceManager& m_sourceManager;
        private:
            RawDumpAttributeHandler& operator=(const RawDumpAttributeHandler& other);

            unsigned int m_lastSeenNonAttributeCommentLine;
            clang::FileID m_lastSeenFile;
    };

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    /// Havok AST consumer class
    class RawDumpASTConsumer : public SemaConsumer
    {
        public:

            RawDumpASTConsumer();
            virtual ~RawDumpASTConsumer();
            virtual void Initialize(ASTContext& context);
            virtual void InitializeSema(Sema& sema);
            // Base callback coming from Clang (used to accumulate all declarations)

            virtual bool HandleTopLevelDecl(DeclGroupRef DG);

            Sema& getSema() const { return *m_sema; }

            ////////////////////////////////////////////////////////////////////////////
            ////////////////////// TEMPORARY ATTRIBUTES HANDLER ////////////////////////
            /////// TO BE REMOVED WHEN WE USE THE PROPER SYNTAX ALL OVER THE SDK ///////
            ////////////////////////////////////////////////////////////////////////////

            // fix declaration attributes
            void fixDeclarationAttributes();

            void fixDocComments();

            ////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////

        protected:

            // List of declarations, declarations are collected and then dumped in a second phase
            std::vector<const clang::Decl*> m_decls;

            // AST context used during consumption of the AST
            ASTContext* m_context;

            // clang Sema instance used to perform semantic analysis
            Sema* m_sema;

        private:

            void fixDeclarationAttributesRecursive(clang::Decl* decl);
            void fixSpecializationAttributesRecursive(clang::NamedDecl* spec, const clang::NamedDecl* tpl);

            void associateDocCommentsRecursive(clang::Decl* decl);
            void associateDocComments(clang::Decl* decl);
    };
}

#endif //RAW_DUMP_H

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
