// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include "pch.h"
#include "filter/ReflectFalseFilter.h"
#include "utils/Database.h"
#include "utils/StlUtils.h"

static void checkFields(Database& db, clang::CXXRecordDecl* recDecl)
{
    if(db.isReflected(recDecl))
    {
        for(clang::DeclContext::specific_decl_iterator<clang::FieldDecl> it( recDecl->decls_begin() ), end(recDecl->decls_end()); it != end; ++it)
        {
            if(db.getAttributeValue(*it, "hk::Reflect", true) == false)
            {
                if(db.getAttributeValue(recDecl, "hk::Retargetable", true))
                {
                    db.addAttribute(recDecl, "hk::Retargetable(false)");
                }
                break;
            }
        }
    }
}


void ReflectFalseFilter::run(Database& db)
{
    for(Database::FileDeclMapType::const_iterator fit = db.inputFilesDecls.begin();
        fit != db.inputFilesDecls.end();
        ++fit)
    {
        const Database::DeclListType& declList = fit->second.decls;

        // For every named declaration.
        for(Database::DeclListType::const_iterator dit = declList.begin();
            dit != declList.end();
            ++dit)
        {
            if(clang::CXXRecordDecl* recDecl = clang::dyn_cast<clang::CXXRecordDecl>(*dit))
            {
                checkFields(db, recDecl);
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
