// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include "pch.h"
#include "filter/ReflectAttrFilter.h"
#include "utils/Database.h"
#include "utils/StlUtils.h"

PRAGMA_WARNING_PUSH
    #include <clang/AST/RecursiveASTVisitor.h>
PRAGMA_WARNING_POP

ReflectAttrFilter::~ReflectAttrFilter()
{
}

struct ReflectFromSpecialization : public clang::RecursiveASTVisitor<ReflectFromSpecialization>
{
    ReflectFromSpecialization(Database& db) : m_db(db) {}
    bool VisitClassTemplateSpecializationDecl(clang::ClassTemplateSpecializationDecl* specDecl)
    {
        if( specDecl->getName() == "ReflectionOf" )
        {
            auto& targs = specDecl->getTemplateInstantiationArgs();
            if( targs.size() == 1 )
            {
                auto arg = targs.get(0);
                if( const clang::Type* type = arg.getAsType().getTypePtrOrNull() )
                {
                    if( auto etype = clang::dyn_cast<clang::EnumType>(type) )
                    {
                        
                        auto edecl = etype->getDecl();
                        if(m_db.getAttributeValue<bool>(edecl, "hk::Reflect", false) )
                        {
                            hkLog.warning(edecl, "Use HK_REFLECT_ENUM instead of hk::Reflect(true)");
                        }
                        else
                        {
                            hkLog.debug("Due to specialization of ReflectionOf, marking %s for reflection", edecl->getNameAsString().c_str());
                            m_db.addAttribute(edecl, "hk::Reflect(true)");
                        }
                    }
                    else if( auto rdecl = type->getAsCXXRecordDecl() )
                    {
                        // check for typedef. typedefs specialize on the TAG. we have to recover the type from its tag
                        // e.g. struct hkReflect::Typedef::hkVector4_Tag : hkReflect::Typedef::Tag<hkVector4> {};
                        std::string rname = rdecl->getQualifiedNameAsString();
                        if( rname.find("hkReflect::Typedef") == 0)
                        {
                            // Decl is hkReflect::Typedef::*
                            bool validTypedefSpec = false;
                            if (rdecl->getNumBases() != 0)
                            {
                                if (auto tagType = clang::dyn_cast<clang::TemplateSpecializationType>(rdecl->bases_begin()->getType()))
                                {
                                    if (tagType->getNumArgs() > 0 && tagType->getArg(0).getKind() == clang::TemplateArgument::Type)
                                    {
                                        // Parent of decl has the form hkReflect::Typedef::Tag<T>; get T.
                                        clang::QualType fqt = tagType->getArg(0).getAsType();
                                        if (auto eltype = clang::dyn_cast<clang::ElaboratedType>(fqt))
                                        {
                                            fqt = eltype->getNamedType();
                                        }
                                        if (auto ttype = clang::dyn_cast<clang::TypedefType>(fqt))
                                        {
                                            // T is a typedef.
                                            auto tdecl = ttype->getDecl();
                                            if (m_db.getAttributeValue<bool>(tdecl, "hk::Reflect", false))
                                            {
                                                hkLog.warning(tdecl, "Reflecting a typedef with an hk::Reflect attribute is unnecessary when using HK_REFLECT_TYPEDEF.");
                                            }
                                            else
                                            {
                                                hkLog.debug("Due to specialization of ReflectionOf, marking %s for reflection", tdecl->getNameAsString().c_str());
                                                m_db.addAttribute(tdecl, "hk::Reflect(true)");
                                            }

                                            // Remember the tag for lookups later, store in the TypedefDecl as a hk::Type attribute.
                                            m_db.addAttribute(tdecl, formatString("hk::Type(%s)", rname.c_str()));

                                            // Attach attributes in the HK_REFLECT_TYPEDEF to the decl
                                            for (auto attr : m_db.getAllAttributes(specDecl))
                                            {
                                                // Attach the attribute to the typedef decl.
                                                tdecl->addAttr(const_cast<clang::AnnotateAttr*>(attr));
                                            }

                                            validTypedefSpec = true;
                                        }
                                    }
                                }
                            }
                            if (!validTypedefSpec)
                            {
                                hkLog.warning(specDecl,
                                    "ReflectionOf specialization looks like the reflection of a typedef but it is not "
                                    "well formed, ignoring it");
                            }
                        }
                    }
                }
            }
        }
        return true;
    }
    Database& m_db;
private:
    void operator=(ReflectFromSpecialization&);
};


void ReflectAttrFilter::run(Database& db)
{
    ReflectFromSpecialization(db).TraverseDecl(db.getRoot());
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
