// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include "pch.h"
#include "filter/NoRawRefObjFilter.h"
#include "utils/Database.h"
#include "utils/StlUtils.h"
#include "utils/ElementUtils.h"

#include <map>
PRAGMA_WARNING_PUSH
    #include <clang/AST/RecursiveASTVisitor.h>
PRAGMA_WARNING_POP

static void checkFields(Database& db, std::map<const clang::Type*, bool>& typeCache, clang::CXXRecordDecl* recDecl)
{
    // Reflected Records
    if (db.isReflected(recDecl))
    {
        for (clang::DeclContext::specific_decl_iterator<clang::FieldDecl> it(recDecl->decls_begin()), end(recDecl->decls_end()); it != end; ++it)
        {
            const clang::FieldDecl* decl = *it;

            // Serialized fields in reflected records
            if (db.isReflected(decl) && !db.isOpaqueTypeAllowed(decl) && !db.getAttribute(decl, "hk::Type"))
            {
                clang::QualType declType = decl->getType();
                const clang::Type* declTypeForLookup = declType.getTypePtr();

                bool isError = false;
                auto cacheValue = typeCache.find(declTypeForLookup);
                if (cacheValue == typeCache.end())
                {
                    // Pointer fields according to clang (so T* and not hkRefPtr, hkViewPtr etc)
                    if (auto asPtr = clang::dyn_cast<clang::PointerType>(declType))
                    {
                        clang::QualType subType = asPtr->getPointeeType();

                        // T* where T is a record
                        const clang::CXXRecordDecl* rd = getCXXRecordFrom(subType);
                        while (rd)
                        {
                            checkIsDefinition(rd);
                            // Something named "hkReferencedObject" in the visible hierarchy
                            if (rd->getName().compare("hkReferencedObject") == 0)
                            {
                                isError = true;
                                break;
                            }

                            // Else keep walking up until we hit something or run out of bases. We are only looking at the primary hierarchy
                            rd = rd->getNumBases() ? rd->bases_begin()->getType()->getAsCXXRecordDecl() : nullptr;
                        }
                    }

                    typeCache[declTypeForLookup] = isError;
                }
                else
                {
                    isError = cacheValue->second;
                }

                if (isError)
                {
                    hkLog.error(recDecl, "'%s' is a raw pointer to a hkReferencedObject", decl->getQualifiedNameAsString().c_str());
                }
            }
        }
    }
}

void NoRawRefObjFilter::run(Database& db)
{
    for (Database::FileDeclMapType::const_iterator fit = db.inputFilesDecls.begin();
        fit != db.inputFilesDecls.end();
        ++fit)
    {
        const Database::DeclListType& declList = fit->second.decls;
        std::map<const clang::Type*, bool> typeIsRawRefObjPtr;

        // For every named declaration.
        for (Database::DeclListType::const_iterator dit = declList.begin();
            dit != declList.end();
            ++dit)
        {
            if (clang::CXXRecordDecl* recDecl = clang::dyn_cast<clang::CXXRecordDecl>(*dit))
            {
                checkFields(db, typeIsRawRefObjPtr, recDecl);
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
