// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include "pch.h"
#include "filter/FieldSetterLinkFilter.h"
#include "utils/Database.h"
#include "utils/StlUtils.h"
#include "utils/ElementUtils.h"

static void checkRecord(Database& db, clang::CXXRecordDecl* recDecl, std::set<std::string>& alreadyDone)
{
    // Much of this logic duplicates that in GenerateTypes.cpp, since we need to figure out if it would have a setter to set this attribute
    // Eventually we should cache this
    if(db.isReflected(recDecl))
    {
        const std::string& cxxName = db.getScopedMangledName(recDecl);

        auto insertRet = alreadyDone.insert(cxxName);
        if (!insertRet.second)
        {
            return;
        }
        const std::string& fieldPrefix = db.getAttributeValue<std::string>(recDecl, "hk::FieldPrefix");
        bool validationRequired = false;

        for (auto mit = recDecl->method_begin(); mit != recDecl->method_end(); ++mit)
        {
            if ((*mit)->getNameAsString() == "validateContract")
            {
                validationRequired = true;
                break;
            }
        }

        if (!validationRequired && recDecl->bases_begin())
        {
            if (clang::CXXRecordDecl* parentRecord = recDecl->bases_begin()->getType()->getAsCXXRecordDecl())
            {
                checkRecord(db, parentRecord, alreadyDone);
                validationRequired = db.getAttributeValue(parentRecord, "hk::Validate", false);
            }
        }

        for (clang::DeclContext::specific_decl_iterator<clang::FieldDecl> recDeclIt(recDecl->decls_begin()), end(recDecl->decls_end()); recDeclIt != end; ++recDeclIt)
        {
            // Every field in every reflected decl
            const clang::FieldDecl* fieldDecl = *recDeclIt;

            const std::string& fieldName = fieldDecl->getNameAsString();
            const std::string& cleanFieldName = fieldNameWithoutPrefix(fieldPrefix, fieldName);

            if (auto setterAttr = db.getAttributeValue< Optional<Attribute> >(fieldDecl, "hk::FieldSetter"))
            {
                const std::string& lookFor = (*setterAttr)["value"] ? *(*setterAttr)["value"] : "set" + cleanFieldName;

                for (auto it = recDecl->method_begin(); it != recDecl->method_end(); ++it)
                {

                    clang::CXXMethodDecl* method = *it;
                    const std::string& methodName = method->getNameAsString();
                    // Check the name
                    if (llvm::StringRef(methodName).equals_lower(lookFor))
                    {
                        if (method->isStatic() || !db.isReflected(method))
                        {
                            continue;
                        }

                        clang::QualType resultType = method->getResultType();
                        if (!(resultType->isVoidType() || resultType->isBooleanType() || db.getScopedMangledName(resultType) == "hkResult"))
                        {
                            continue;
                        }

                        if (method->getNumParams() != 1)
                        {
                            continue;
                        }

                        clang::QualType paramType = method->getParamDecl(0)->getType();

                        clang::QualType subType;
                        if (auto asPtr = clang::dyn_cast<clang::PointerType>(paramType))
                        {
                            subType = asPtr->getPointeeType();
                        }
                        else if (auto asRef = clang::dyn_cast<clang::ReferenceType>(paramType))
                        {
                            subType = asRef->getPointeeType();
                        }

                        if (!subType.isNull() && !subType.isConstQualified() &&
                            subType.getCanonicalType().getUnqualifiedType() == fieldDecl->getType().getCanonicalType().getUnqualifiedType())
                        {
                            continue;
                        }

                        // Valid setter found.
                        db.addAttribute(method, formatString("hk::SetsField((hkUlong)reinterpret_cast<const hkReflect::Type*>(&%s::_Auto::%s::typeData))", cxxName.c_str(), fieldName.c_str()), method->getSourceRange());
                        break;
                    }
                }
            }

            // Don't bother checking this if we have already found validation
            if (!validationRequired)
            {
                if (clang::CXXRecordDecl* fieldDeclRecord = fieldDecl->getType()->getAsCXXRecordDecl())
                {
                    checkRecord(db, fieldDeclRecord, alreadyDone);
                    if (const clang::AnnotateAttr* attr = db.getAttributeInHierarchy(fieldDeclRecord, "hk::Validate"))
                    {
                        validationRequired = db.getAttributeValue<bool>(attr);
                    }
                }

                if (!validationRequired)
                {
                    if (const clang::AnnotateAttr* attr = db.getAttributeInHierarchy(fieldDecl, "hk::Validate"))
                    {
                        validationRequired = db.getAttributeValue<bool>(attr);
                    }
                }
            }
        }

        if (validationRequired)
        {
            // The user may have already specified their own choice
            if (!db.getAttribute(recDecl, "hk::Validate"))
            {
                db.addAttribute(recDecl, "hk::Validate(true)", recDecl->getSourceRange());
            }
        }
    }
}


void FieldSetterLinkFilter::run(Database& db)
{
    std::set<std::string> recordsAlreadyDone;
    for (Database::FileDeclMapType::const_iterator fit = db.inputFilesDecls.begin();
        fit != db.inputFilesDecls.end();
        ++fit)
    {
        const Database::DeclListType& declList = fit->second.decls;

        // For every named declaration.
        for(Database::DeclListType::const_iterator dit = declList.begin();
            dit != declList.end();
            ++dit)
        {
            if(clang::CXXRecordDecl* recDecl = clang::dyn_cast<clang::CXXRecordDecl>(*dit))
            {
                checkRecord(db, recDecl, recordsAlreadyDone);
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
