// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef ENGINE_NODE_DATABASE_FILTER_H
#define ENGINE_NODE_DATABASE_FILTER_H

#include "filter/DatabaseFilter.h"

/// Havok Engine specific hkeNode filter.
/// This manipulator expands the compact hkeNode specific reflection markup into the
/// generic Havok markup required for the rest of the processing.
/// This manipulator also performs a series of checks on the hkeNode classes encountered
/// making sure that they match the Engine requirements.
class EngineNodeDatabaseFilter : public DatabaseFilter
{
    public:
        /// Virtual destructor.
        virtual ~EngineNodeDatabaseFilter();

        /// Perform the actual manipulation on the database.
        virtual void run(Database& db);
};

#endif // ENGINE_NODE_DATABASE_FILTER_H

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
