// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 MAC OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include "pch.h"

PRAGMA_WARNING_PUSH
#include <llvm/Support/Host.h>
#include <llvm/Support/ManagedStatic.h>
#include <clang/Frontend/Utils.h>
#include <clang/Frontend/FrontendDiagnostic.h>
#include <clang/Frontend/TextDiagnosticPrinter.h>
#include <clang/Lex/Preprocessor.h>
#include <clang/Lex/ModuleLoader.h>
#include <clang/Parse/ParseAST.h>
#include <clang/Basic/TargetInfo.h>
#include <clang/Basic/FileManager.h>
#include <clang/Lex/HeaderSearch.h>
#include <clang/Sema/Sema.h>
#include <clang/Sema/SemaDiagnostic.h>
#include <clang/Frontend/ASTConsumers.h>
#include <llvm/Support/raw_os_ostream.h>
#include <llvm/Support/FileSystem.h>
PRAGMA_WARNING_POP

#include "rawDump.h"
#include "utils/Database.h"
#include "utils/Filesystem.h"
#include "utils/TkbmsRegistry.h"
#include "utils/ProfilePoint.h"
#include "utils/Logger.h"
#include "reflect/Generators.h"

#include "filter/EngineNodeDatabaseFilter.h"
#include "filter/ReflectAttrFilter.h"
#include "filter/DeclareClassFilter.h"
#include "filter/ReflectFalseFilter.h"
#include "filter/AddSetterFilter.h"
#include "filter/ExtraAttributesFilter.h"
#include "filter/NoRawRefObjFilter.h"
#include "filter/FieldSetterLinkFilter.h"

#ifdef _WIN32
#include <Shlwapi.h>
#include <winbase.h>
#include <windows.h>
static inline bool s_fileNameMatch(const char* path, const char* pattern)
{
    static char path_s[MAX_PATH]; // static storage
    strncpy(path_s, path, MAX_PATH - 1);
    path_s[MAX_PATH - 1] = 0;
    PathStripPathA(path_s);
    return (PathMatchSpecA(path_s, pattern) == TRUE);
}
#undef GetCurrentDirectory // remove annoying define from windows header
#else
#include <fnmatch.h>
#include <libgen.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

static inline bool s_fileNameMatch(const char* path, const char* pattern)
{
    const char* base = basename(const_cast<char*>(path));
    return (fnmatch(pattern, base, 0) == 0);
}
#endif


std::vector<std::string>* s_globalIncludePaths = nullptr;

void setGlobalIncludePaths(std::vector<std::string>* sm)
{
    // There can only be one set of include paths
    assert(s_globalIncludePaths == nullptr);
    s_globalIncludePaths = sm;
}

std::vector<std::string>* getGlobalIncludePaths()
{
    return s_globalIncludePaths;
}

namespace Havok
{
    // Module loader
    class ModuleLoader : public clang::ModuleLoader
    {
    public:

        virtual ModuleLoadResult loadModule(SourceLocation, ModuleIdPath, Module::NameVisibilityKind, bool)
        {
            assert(0);
            return ModuleLoadResult();
        }

        virtual void makeModuleVisible(Module*, Module::NameVisibilityKind, SourceLocation, bool)
        {

        }
    };
    // Preprocessor callbacks used to exclude specific included files (with #include)
    // When the preprocessor processes a file, it will generate callbacks to this object
    // on various events, when an inclusion directive is detected we will simply look
    // it up in our set of excluded inclusion, and if something matches we will basically
    // override that with an empty buffer.
    class FilenamePatternExcluder : public clang::PPCallbacks
    {
    public:

        FilenamePatternExcluder(clang::Preprocessor& preprocessor, clang::SourceManager& sourceManager, Filesystem& fs, const std::string& trackingFileName)
            : PPCallbacks(), m_sourceManager(sourceManager), m_preprocessor(preprocessor), m_fs(fs), m_outputFileName(trackingFileName)
        {}

        ~FilenamePatternExcluder()
        {
            if(!m_outputFileName.empty())
            {
                m_fs.openRW(m_outputFileName) << m_trackingFileContent;
            }
        }

        void addExcludedPattern(const std::string& str)
        {
            m_excludedPatterns.push_back(str);
        }

        virtual void InclusionDirective(SourceLocation srcLoc, const Token&, StringRef fileName, bool, CharSourceRange, const FileEntry *file, StringRef, StringRef, const Module *)
        {
            m_preprocessor.SetSuppressIncludeNotFoundError(false);
            bool addFileToList = true;
            for(unsigned int i = 0; i < m_excludedPatterns.size(); ++i)
            {
                if(s_fileNameMatch(fileName.str().c_str(), m_excludedPatterns[i].c_str()))
                {
                    if(file)
                    {
                        // file was found

                        // The trick to replace the file contents is a bit hacky and leaks the file descriptor. This causes
                        // problems when some instances have a file open for read and another tries to write into it.
                        // Calling getBufferForFile triggers the read-into-memory+close of the file wich prevents the leak
                        // of the FD. The best way of fixing this though would be to find a way to skip the include.
                        llvm::MemoryBuffer* buf = m_sourceManager.getFileManager().getBufferForFile(file);
                        m_sourceManager.overrideFileContents(file, llvm::MemoryBuffer::getNewMemBuffer(0), false);
                        delete buf;
                    }
                    else
                    {
                        // file was not found (but as it matches one of the excluded patterns we ignore it anyway)
                        m_preprocessor.SetSuppressIncludeNotFoundError(true);
                        addFileToList = false;
                    }
                    break;
                }
            }

            if(addFileToList)
            {
                if( !file )
                {
                    std::string locStr;
                    llvm::raw_string_ostream os(locStr);
                    srcLoc.print(os, m_sourceManager);
                    os.flush();
                    throw FatalError(m_sourceManager, srcLoc, "%s: Unable to open include file '%s'.", locStr.c_str(), fileName.str().c_str());
                }
                const std::string& absoluteFileName = Filesystem::fixSeparatorsAndRemoveLeadingDot(file->getName());
                m_trackingFileContent.append(absoluteFileName);
                m_trackingFileContent.append("\n");

                // Check if the header has an associated .hkReflect file
                std::string reflectFileName = file->getName();
                auto dot = reflectFileName.rfind('.');
                if (dot != std::string::npos)
                {
                    reflectFileName.replace(dot, std::string::npos, ".hkReflect");

                    if (std::ifstream(reflectFileName).is_open())
                    {
                        m_trackingFileContent.append(reflectFileName);
                        m_trackingFileContent.append("\n");
                    }
                }
            }
        }

    protected:

        // Included file patterns that will be skipped, these string should contain
        // OS-style wildcards to exclude sets of files based on their name.
        std::vector<std::string> m_excludedPatterns;

        // Source manager used to exclude all the specified inclusions.
        clang::SourceManager& m_sourceManager;

        // Preprocessor used during parsing of the source
        clang::Preprocessor& m_preprocessor;

        // Content of the tracking file
        std::string m_trackingFileContent;

        Filesystem& m_fs;

        // Tracking file name
        std::string m_outputFileName;

    private:
        FilenamePatternExcluder& operator=(const FilenamePatternExcluder& other);
    };
}

namespace Havok
{
    // Remember includes (including filtered ones) which occur in input files.
    class DirectIncludeFinder : public clang::PPCallbacks
    {
    public:
        DirectIncludeFinder(clang::SourceManager& sourceManager, Database::DirectIncludes& directIncludes, std::vector<std::string> inputFileNames
            , const llvm::cl::list<std::string>& remapInclude)
            : PPCallbacks()
            , m_sourceManager(sourceManager)
            , m_directIncludes(directIncludes)
        {
            // Build a set of input files, for faster querying.
            for (auto inputFileIter = inputFileNames.begin(); inputFileIter != inputFileNames.end(); ++inputFileIter)
            {
                const std::string inputFile = *inputFileIter;
                m_includeFiles.insert(toLower(Filesystem::absoluteCanonicalPath(std::string(inputFile.data(), inputFile.size()))));
            }

            // Remap includes from one dir to another
            if (remapInclude.size() > 0)
            {
                // Should be an even number of [old]->[new] paths
                for (size_t i = 0; i < remapInclude.size() - 1; i += 2)
                {
                    m_remapInclude.push_back(std::make_pair(Filesystem::absoluteCanonicalPath(remapInclude[i]), Filesystem::absoluteCanonicalPath(remapInclude[i + 1])));
                }
            }
        }

        virtual void InclusionDirective(SourceLocation srcLoc, const Token&, StringRef fileName, bool, CharSourceRange, const FileEntry* fileEntry, StringRef, StringRef, const Module *)
        {
            StringRef sourceFile = m_sourceManager.getFilename(srcLoc);
            const std::string sourceFileName = Filesystem::absoluteCanonicalPath(std::string(sourceFile.data(), sourceFile.size()));

            if (m_includeFiles.find(toLower(sourceFileName)) != m_includeFiles.end())
            {
                // The include is in one of the input files, so store the details.

                Database::DirectInclude di;
                di.m_sourceFile = sourceFileName;
                std::string pathToFile;
                if ( fileEntry )
                {
                    // The file existed, so use its path.
                    pathToFile = fileEntry->getName();
                    di.m_resolved = true;
                }
                else
                {
                    // The file did not exist, so for now, just remember the path in the include.
                    pathToFile = fileName.str();
                    di.m_resolved = false;
                }
                const std::string canonicalPath = Filesystem::getCanonicalizedPath(pathToFile.data(), pathToFile.size());
                std::string fname;
                Filesystem::getFileNameAndPath(canonicalPath, fname, di.m_path);

                for (auto const& remap : m_remapInclude)
                {
                    if (di.m_path.find(remap.first) == 0)
                    {
                        di.m_path.replace(0, remap.first.size(), remap.second);
                    }
                }

                m_directIncludes.insert(Database::DirectIncludes::value_type(fname, di));
            }
        }

    protected:
        // Source manager used to exclude all the specified inclusions.
        clang::SourceManager& m_sourceManager;

        Database::DirectIncludes& m_directIncludes;

        // The include files as a set, because we query regularly. We convert to lower case.
        std::set<std::string> m_includeFiles;
        std::vector<std::pair<std::string, std::string> > m_remapInclude;

    private:
        DirectIncludeFinder& operator=(const DirectIncludeFinder& other);
    };
}

//namespace clang{ ASTConsumer *clang::CreateASTDumperXML(raw_ostream &OS); }

int clangMain(TkbmsRegistry& tkbms, Filesystem& fs, const std::string& trackingFileName, bool printStats, bool binding
              , const llvm::cl::list<std::string>& cppDefines, const llvm::cl::list<std::string>& includePathsInput, const llvm::cl::list<std::string>& excludeFileNames
              , const llvm::cl::list<std::string>& excludeFilePatterns, const llvm::cl::list<std::string>& passAtttributes, const llvm::cl::list<std::string>& forceIncludes, bool generateMemoryTracker
              , bool generateClassLists, const std::vector<std::string>& inputFileNames, const std::string& progName, const std::string& outputFileDir
              , const std::string& preamble, const std::string& postamble, const std::string& preambleCpp, const std::string& postambleCpp, const llvm::cl::list<std::string>& addAttributes
              , bool noRawRefObjPtr, const llvm::cl::list<std::string>& remapInclude, bool outputTkbms)
{
    int exitStatus;

    std::vector<std::string> includePaths(includePathsInput.begin(), includePathsInput.end());
#ifdef _WIN32
    SetErrorMode(SEM_NOGPFAULTERRORBOX);
#endif

    //_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_DELAY_FREE_MEM_DF | _CRTDBG_CHECK_EVERY_1024_DF | _CRTDBG_LEAK_CHECK_DF );

    llvm::MemoryBuffer* emptyMemoryBuffer = llvm::MemoryBuffer::getNewMemBuffer(0, "emptyMemoryBuffer");
    {
        llvm::IntrusiveRefCntPtr<clang::DiagnosticOptions> diagnosticOptions(new clang::DiagnosticOptions());
        #if defined(_WIN32)
            diagnosticOptions->setFormat(clang::DiagnosticOptions::Msvc);
        #endif
        clang::TextDiagnosticPrinter diagnosticConsumer(llvm::errs(), diagnosticOptions.getPtr(), false);
        llvm::IntrusiveRefCntPtr<clang::DiagnosticIDs> diagnosticIDs(new clang::DiagnosticIDs());
        clang::DiagnosticsEngine diagnostics(diagnosticIDs, diagnosticOptions.getPtr(), &diagnosticConsumer, false);
        diagnostics.setErrorLimit(5);
        // ignored warnings
        diagnostics.setDiagnosticMapping(clang::diag::warn_undefined_internal, clang::diag::MAP_IGNORE, clang::SourceLocation()); //-Wno-undefined-internal
        diagnostics.setIgnoreAllWarnings(true);

        clang::TargetOptions targetOptions;
        targetOptions.Triple = llvm::sys::getDefaultTargetTriple();
        clang::TargetInfo* targetInfo = clang::TargetInfo::CreateTargetInfo(diagnostics, &targetOptions );
        clang::FileSystemOptions filesystemOptions;
        llvm::IntrusiveRefCntPtr<clang::HeaderSearchOptions> headerSearchOptions(new clang::HeaderSearchOptions());
        clang::FileManager fileManager(filesystemOptions);
        clang::SourceManager sourceManager(diagnostics, fileManager);
        Havok::ModuleLoader moduleLoader;
        clang::LangOptions langOptions;
        clang::HeaderSearch headerSearch(headerSearchOptions, sourceManager, diagnostics, langOptions, targetInfo/*.getPtr()*/);
        langOptions.CPlusPlus = 1;
        langOptions.CPlusPlus11 = 1;
        langOptions.CPlusPlus1y = 0;
        langOptions.Bool = 1;
        langOptions.ConstStrings = 1;
        langOptions.AssumeSaneOperatorNew = 1;
        langOptions.ImplicitInt = 0;
        langOptions.ElideConstructors = 0;
        langOptions.WChar = 1;
        #if defined(_WIN32)
            langOptions.MicrosoftExt = 1;
            langOptions.MicrosoftMode = 1;
        #endif

        // A map of #included file to the (input) file in which it was #included.
        Database::DirectIncludes directIncludes;

        llvm::IntrusiveRefCntPtr<clang::PreprocessorOptions> preprocessorOptions(new clang::PreprocessorOptions());
        clang::Preprocessor preprocessor(preprocessorOptions, diagnostics, langOptions, targetInfo, sourceManager, headerSearch, moduleLoader);

        ////////////////////////////////////////////////////////////////////////////
        ////////////////////// TEMPORARY ATTRIBUTES HANDLER ////////////////////////
        /////// TO BE REMOVED WHEN WE USE THE PROPER SYNTAX ALL OVER THE SDK ///////
        ////////////////////////////////////////////////////////////////////////////

        Havok::RawDumpAttributeHandler attributeHandler(sourceManager);

        preprocessor.addCommentHandler(&attributeHandler);
        ////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////

        std::vector<std::string> inputFileNamesAbsolute;
        for (auto& n : inputFileNames)
        {
            inputFileNamesAbsolute.push_back(Filesystem::absoluteCanonicalPath(n));
        }

        Havok::RawDumpDocCommentHandler docCommentHandler(sourceManager, inputFileNamesAbsolute);
        preprocessor.addCommentHandler(&docCommentHandler);

        clang::FrontendOptions frontendOptions;
        frontendOptions.SkipFunctionBodies = 1;

        std::string errorInfo;
        {
            // Gather input files into a memory
            std::string mainFileText;
            llvm::raw_string_ostream stream(mainFileText);

            //llvm::sys::Path cwd = llvm::sys::Path::GetCurrentDirectory();
            // These defines are always set
            stream << "#define HK_CONFIG_THREAD 1\n#define HK_CONFIG_SIMD 2\n#define __HAVOK_PARSER__\n\n";

            // -D
            for( llvm::cl::list<std::string>::const_iterator iter = cppDefines.begin(), end = cppDefines.end(); iter != end; ++iter )
            {
                std::string::size_type index = iter->find_first_of('=');
                std::string macro, value;
                if(index != std::string::npos)
                {
                    macro = iter->substr(0, index);
                    value = iter->substr(index+1, std::string::npos);
                }
                else
                {
                    macro = (*iter);
                }

                stream << "#define " << macro << ' ' << value << '\n';
            }

            // -I
            for( std::vector<std::string>::iterator iter = includePaths.begin(), end = includePaths.end(); iter != end; ++iter )
            {
                std::string sv = Filesystem::absoluteCanonicalPath(*iter);

                *iter = sv;
                headerSearchOptions->AddPath(sv, clang::frontend::Angled, false, false);
            }

            // -exclude
            {
                // Do not free buffers associated with the compiler invocation
                preprocessorOptions->RetainRemappedFileBuffers = true;
                for( std::vector<std::string>::const_iterator iter = excludeFileNames.begin(), end = excludeFileNames.end(); iter != end; ++iter )
                {
                    preprocessorOptions->addRemappedFile(iter->c_str(), emptyMemoryBuffer);
                }
            }

            // -A
            for( llvm::cl::list<std::string>::const_iterator iter = passAtttributes.begin(), end = passAtttributes.end(); iter != end; ++iter )
            {
                std::string::size_type index = iter->find_first_of('=');
                if(index != std::string::npos)
                {
                    std::string macro, value;
                    macro = iter->substr(0, index);
                    value = iter->substr(index+1, std::string::npos);
                }
            }

            for( std::vector<std::string>::const_iterator iter = forceIncludes.begin(), end = forceIncludes.end(); iter != end; ++iter )
            {
                stream << "#include<" << iter->c_str() << ">\n";
            }

            for( std::vector<std::string>::const_iterator iter = inputFileNames.begin(), end = inputFileNames.end(); iter != end; ++iter )
            {
                stream << "#include<" << iter->c_str() << ">\n";
            }
            stream.flush();

            llvm::MemoryBuffer* mainBuf = llvm::MemoryBuffer::getMemBufferCopy( llvm::StringRef(mainFileText.c_str(), mainFileText.size()), "masterInputFile" );
            sourceManager.createMainFileIDForMemBuffer(mainBuf);

            // Dump the file given to clang
//          std::ofstream o("D:/new_file.cpp");
//          llvm::raw_os_ostream lo(o);
//          lo << mainBuf->getBuffer();
        }

        // Add the current working directory as a default search path
        {
            const std::string absPathStr(".");
            headerSearchOptions->AddPath(Filesystem::absoluteCanonicalPath(absPathStr), clang::frontend::System, false, false);
        }

        {
            const std::string& absPathStr = formatString("%s/../../../lib/clang/%d.%d/include", progName.c_str(), LLVM_VERSION_MAJOR, LLVM_VERSION_MINOR);
            headerSearchOptions->AddPath(Filesystem::absoluteCanonicalPath(absPathStr), clang::frontend::System, false, false);
        }

        {
            const std::string& absPathStr = formatString("%s/../../../lib/HavokStlStub", progName.c_str(), LLVM_VERSION_MAJOR, LLVM_VERSION_MINOR);
            headerSearchOptions->AddPath(Filesystem::absoluteCanonicalPath(absPathStr), clang::frontend::System, false, false);
        }

        // Try one extra dir up as well, so we can execute from the debug output location
        {
            const std::string& absPathStr = formatString("%s/../../../../lib/clang/%d.%d/include", progName.c_str(), LLVM_VERSION_MAJOR, LLVM_VERSION_MINOR);
            headerSearchOptions->AddPath(Filesystem::absoluteCanonicalPath(absPathStr), clang::frontend::System, false, false);
        }

        {
            const std::string& absPathStr = formatString("%s/../../../../lib/HavokStlStub", progName.c_str(), LLVM_VERSION_MAJOR, LLVM_VERSION_MINOR);
            headerSearchOptions->AddPath(Filesystem::absoluteCanonicalPath(absPathStr), clang::frontend::System, false, false);
        }

        // We also add the output directory as an implicit include path
        includePaths.push_back(outputFileDir);

        Havok::DirectIncludeFinder* directIncludeFinder = new Havok::DirectIncludeFinder(sourceManager, directIncludes, inputFileNamesAbsolute, remapInclude);
        preprocessor.addPPCallbacks(directIncludeFinder); // the preprocessor is now owner of the DirectIncludeFinder;

        Havok::FilenamePatternExcluder* filenamePatternExcluder = new Havok::FilenamePatternExcluder(preprocessor, sourceManager, fs, trackingFileName);
        preprocessor.addPPCallbacks(filenamePatternExcluder); // the preprocessor is now owner of the FilenamePatternExcluder

        setGlobalIncludePaths(&includePaths);
        // -exclude-pattern
        {
            for (std::vector<std::string>::const_iterator iter = excludeFilePatterns.begin(), end = excludeFilePatterns.end(); iter != end; ++iter)
            {
                filenamePatternExcluder->addExcludedPattern(*iter);
            }
        }

        clang::InitializePreprocessor( preprocessor, clang::PreprocessorOptions(), *headerSearchOptions, frontendOptions);
        Havok::RawDumpASTConsumer consumer;

        clang::ASTContext astcontext(langOptions, sourceManager, targetInfo, preprocessor.getIdentifierTable(), preprocessor.getSelectorTable(), preprocessor.getBuiltinInfo(), 0);

        //clang::ASTConsumer* xml = clang::CreateASTDumper("");
        //diagnostics.getClient()->BeginSourceFile(langOptions);
        //clang::ParseAST(preprocessor, xml, astcontext);
        //diagnostics.getClient()->EndSourceFile();
        //return 0;

        PROFILE_POINT(Setup);


        //llvm::raw_fd_ostream tmp("C:/tmp.cpp", errorInfo);
        //clang::PreprocessorOutputOptions opts;
        //opts.ShowCPP = 1;
        //clang::DoPrintPreprocessedInput(preprocessor, &tmp, opts);
        //tmp.close();

        clang::Sema sema(preprocessor, astcontext, consumer, clang::TU_Prefix);

        diagnostics.getClient()->BeginSourceFile(langOptions);
        clang::ParseAST(sema, false, true);
        diagnostics.getClient()->EndSourceFile();
        PROFILE_POINT(Parser);


        exitStatus = diagnostics.hasErrorOccurred() ? 1 : 0;
        if(exitStatus == 0)
        {
            ////////////////////////////////////////////////////////////////////////////
            ////////////////////// TEMPORARY ATTRIBUTES HANDLER ////////////////////////
            /////// TO BE REMOVED WHEN WE USE THE PROPER SYNTAX ALL OVER THE SDK ///////
            ////////////////////////////////////////////////////////////////////////////

            // Fix old-style attributes and doc comments
            consumer.fixDeclarationAttributes();
            consumer.fixDocComments();
            PROFILE_POINT(Fixup);

            ////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////

            // Initialize the database.
            Database db(fs, inputFileNamesAbsolute, astcontext, consumer.getSema(), includePaths, passAtttributes,
                forceIncludes, tkbms, directIncludes, outputFileDir, preamble, postamble, preambleCpp, postambleCpp, outputTkbms);
            PROFILE_POINT(createDatabase);

            // Array of manipulators, could be filled automatically by registering the manipulators.
            std::vector< std::unique_ptr<DatabaseFilter> > manipulators;
            manipulators.push_back(std::unique_ptr<DatabaseFilter>(new ReflectAttrFilter));
            manipulators.push_back(std::unique_ptr<DatabaseFilter>(new EngineNodeDatabaseFilter));
            manipulators.push_back(std::unique_ptr<DatabaseFilter>(new DeclareClassFilter));
            manipulators.push_back(std::unique_ptr<DatabaseFilter>(new ReflectFalseFilter));
            manipulators.push_back(std::unique_ptr<DatabaseFilter>(new AddSetterFilter));
            manipulators.push_back(std::unique_ptr<DatabaseFilter>(new ExtraAttributesFilter(addAttributes)));
            manipulators.push_back(std::unique_ptr<DatabaseFilter>(new FieldSetterLinkFilter));

            if (noRawRefObjPtr)
            {
                manipulators.push_back(std::unique_ptr<DatabaseFilter>(new NoRawRefObjFilter));
            }

            // Perform manipulations.
            for(auto it = manipulators.begin(); it != manipulators.end(); ++it)
            {
                (*it)->run(db);
            }
            db.selfCheck();

            // Generate the classlists.
            if (generateClassLists)
            {
                generateLists(db, generateMemoryTracker);
                PROFILE_POINT(generateLists);
            }

            // Generate the actual types reflection.
            generateTypes(db, generateMemoryTracker, generateClassLists);
            PROFILE_POINT(generateTypes);

            if(binding)
            {
                generateHABinding(db);
                PROFILE_POINT(generateHABinding);
            }
        }

        if(printStats)
            astcontext.PrintStats();
    }

    delete emptyMemoryBuffer;
    llvm::llvm_shutdown();

    return exitStatus;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
