// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 X64 MAC
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef ASSET_CC_COMMON
#define ASSET_CC_COMMON

//#include <Common/Serialize/Util/hkStructureLayout.h>

struct FileConvertOptions
{
    FileConvertOptions();
    int parse(int argc, const char** argv, /*OUT*/hkArray<const char*>& arguments);

    bool m_xml;
    bool m_tagfile;
    bool m_strip;
    unsigned int m_verbose;
    unsigned int m_quiet;
    bool m_convertPhysics;
    bool m_skipUnchanged;
    const char* m_platform;
    const char* m_compendium;
};

enum AssetCcErrorId
{
    // No errors
    FILECONVERT_ERR_NONE = 0,
    // Min AssetCcErrorId error Id
    FILECONVERT_ERR_MIN_ID = 50,

    // Failed to parse
    FILECONVERT_ERR_PARSE_FAIL = FILECONVERT_ERR_MIN_ID,
    // Wrong number of arguments
    FILECONVERT_ERR_PARSE_ARGS,
    // Xml and binary are mutually exclusive
    FILECONVERT_ERR_PARSE_XML_BIN,
    // '-t' option for userdata tag is deprecated
    FILECONVERT_ERR_PARSE_TAG_DEPRECATED,
    // Failed to open file
    FILECONVERT_ERR_FILE_NOT_FOUND,
    // Could not get file contents.
    FILECONVERT_ERR_GET_CONTENTS_FAILED,
    // Failed to save.
    FILECONVERT_ERR_SAVE_FAILED,
    // Can't find the file contents class.
    FILECONVERT_ERR_FILE_CONTENTS_CLASS,
    // Unsupported file format.
    FILECONVERT_ERR_UNSUPPORTED_FORMAT,
    // Conversion skipped (option for AccetCc3 when conversion isn't necessary)
    FILECONVERT_ERR_CONVERSION_SKIPPED,
    // Max AssetCcErrorId error Id
    FILECONVERT_ERR_MAX_ID
};

void HK_CALL FileConvertInit();
void HK_CALL FileConvertQuit();

#endif // ASSET_CC_COMMON

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
