// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if 0
R\
"exclude1(";
R"exclude2()exclude1";
#endif

#pragma once

#if defined(HK_COMPILER_GCC)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define UNPACK_OPT_PARAM(...) __VA_ARGS__
#if defined(HK_FILTER_REFLECT_OPT)
#   undef HK_FILTER_REFLECT_OPT
#endif
#if defined(HK_EXCLUDE_FROM_DATA_REFLECTION)
#   undef HK_EXCLUDE_FROM_DATA_REFLECTION
#endif
#if defined(HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION)
#   undef HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION
#endif
#if defined(HK_REFLECT_TYPE_DATA_ONLY)
#   define HK_FILTER_REFLECT_OPT(x) ((x) & hkReflect::Opt::DATA_ONLY_MASK)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x)
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x)
#elif defined(HK_REFLECT_TYPE_CONSTRUCTABLE)
#   define HK_FILTER_REFLECT_OPT(x) ((x) & hkReflect::Opt::DATA_CONSTRUCTIBLE_MASK)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x)
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x) UNPACK_OPT_PARAM x
#else
#   define HK_FILTER_REFLECT_OPT(x) (x)
#   define HK_EXCLUDE_FROM_DATA_REFLECTION(x) UNPACK_OPT_PARAM x
#   define HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION(x) UNPACK_OPT_PARAM x
#endif

#include <Physics2012/Vehicle/hkpVehicleData.h>


struct hkpVehicleData::_Auto
{    
    struct m_gravity { static const hkReflect::Detail::TypeData typeData;};
    struct m_numWheels { static const hkReflect::Detail::TypeData typeData;};
    struct m_chassisOrientation { static const hkReflect::Detail::TypeData typeData;};
    struct m_torqueRollFactor { static const hkReflect::Detail::TypeData typeData;};
    struct m_torquePitchFactor { static const hkReflect::Detail::TypeData typeData;};
    struct m_torqueYawFactor { static const hkReflect::Detail::TypeData typeData;};
    struct m_extraTorqueFactor { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxVelocityForPositionalFriction { static const hkReflect::Detail::TypeData typeData;};
    struct m_chassisUnitInertiaYaw { static const hkReflect::Detail::TypeData typeData;};
    struct m_chassisUnitInertiaRoll { static const hkReflect::Detail::TypeData typeData;};
    struct m_chassisUnitInertiaPitch { static const hkReflect::Detail::TypeData typeData;};
    struct m_frictionEqualizer { static const hkReflect::Detail::TypeData typeData;};
    struct m_normalClippingAngleCos { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxFrictionSolverMassRatio { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_wheelParams(const void* valuePtr) { const decltype(hkpVehicleData::m_wheelParams)& fieldValue = *reinterpret_cast<const decltype(hkpVehicleData::m_wheelParams)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_wheelParams { static const hkReflect::Detail::TypeData typeData;};
    static inline bool isValid_m_numWheelsPerAxle(const void* valuePtr) { const decltype(hkpVehicleData::m_numWheelsPerAxle)& fieldValue = *reinterpret_cast<const decltype(hkpVehicleData::m_numWheelsPerAxle)*>(valuePtr); return fieldValue.reflectValidate(); }
    struct m_numWheelsPerAxle { static const hkReflect::Detail::TypeData typeData;};
    struct m_chassisFrictionInertiaInvDiag { static const hkReflect::Detail::TypeData typeData;};
    struct m_alreadyInitialised { static const hkReflect::Detail::TypeData typeData;};
    struct Decls { static const hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*,18> decls;};
    static inline bool isValid(const hkpVehicleData& value) { return isValid_m_wheelParams(&value.m_wheelParams) && isValid_m_numWheelsPerAxle(&value.m_numWheelsPerAxle); }
    static inline bool isValidPtr(const void* valuePtr) { return isValid(*reinterpret_cast<const hkpVehicleData*>(valuePtr)); }    
};


struct hkpVehicleData::WheelComponentParams::_Auto
{    
    struct m_radius { static const hkReflect::Detail::TypeData typeData;};
    struct m_mass { static const hkReflect::Detail::TypeData typeData;};
    struct m_width { static const hkReflect::Detail::TypeData typeData;};
    struct m_friction { static const hkReflect::Detail::TypeData typeData;};
    struct m_viscosityFriction { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxFriction { static const hkReflect::Detail::TypeData typeData;};
    struct m_slipAngle { static const hkReflect::Detail::TypeData typeData;};
    struct m_forceFeedbackMultiplier { static const hkReflect::Detail::TypeData typeData;};
    struct m_maxContactBodyAcceleration { static const hkReflect::Detail::TypeData typeData;};
    struct m_axle { static const hkReflect::Detail::TypeData typeData;};
    struct Decls { static const hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*,10> decls;};    
};




#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// CXXRecord: hkpVehicleData
//
struct hkpVehicleData_m_maxFrictionSolverMassRatio_Auto
{
    static const hkReflect::Detail::AggregateOf< hkReal >::Type defaultVal;
};


const hkReflect::Detail::AggregateOf< hkReal >::Type hkpVehicleData_m_maxFrictionSolverMassRatio_Auto::defaultVal = 30.0;



hkReflect::Detail::AddrAndType hkpVehicleData::getExactType() const
{
    return hkReflect::Detail::AddrAndType(this, HK_REFLECT_GET_TYPE( hkpVehicleData ));
}
hkReflect::Detail::TypeRegNode hkpVehicleData_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hkpVehicleData ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hkpVehicleData >::Holder::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::NAME | hkReflect::Opt::VERSION | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::DESTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::SIZE_ALIGN | hkReflect::Opt::DECLS | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReferencedObject ),//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfRecord::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hkpVehicleData"),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VERSION, 2),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::ExplicitWrapper< hkReflect::Opt::DEF_CONSTRUCTOR, hkpVehicleData >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Unknown< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_INCLUDE_IN_CONSTRUCTABLE_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DESTRUCTOR, &hkReflect::Detail::ExplicitWrapper< hkReflect::Opt::DESTRUCTOR, hkpVehicleData >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Unknown< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hkpVehicleData),HK_ALIGN_OF(hkpVehicleData),0)),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECLS, reinterpret_cast<const hkReflect::Detail::DeclsArray*>(&hkpVehicleData::_Auto::Decls::decls)),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hkpVehicleData::_Auto::isValidPtr),))    
};
const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_gravity::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkVector4_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "gravity"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_gravity, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_numWheels::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkInt8_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "numWheels"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_numWheels, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_chassisOrientation::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkRotation_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "chassisOrientation"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_chassisOrientation, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_torqueRollFactor::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "torqueRollFactor"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_torqueRollFactor, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_torquePitchFactor::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "torquePitchFactor"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_torquePitchFactor, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_torqueYawFactor::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "torqueYawFactor"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_torqueYawFactor, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_extraTorqueFactor::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "extraTorqueFactor"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_extraTorqueFactor, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_maxVelocityForPositionalFriction::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxVelocityForPositionalFriction"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxVelocityForPositionalFriction, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_chassisUnitInertiaYaw::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "chassisUnitInertiaYaw"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_chassisUnitInertiaYaw, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_chassisUnitInertiaRoll::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "chassisUnitInertiaRoll"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_chassisUnitInertiaRoll, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_chassisUnitInertiaPitch::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "chassisUnitInertiaPitch"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_chassisUnitInertiaPitch, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_frictionEqualizer::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "frictionEqualizer"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_frictionEqualizer, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_normalClippingAngleCos::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "normalClippingAngleCos"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_normalClippingAngleCos, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_maxFrictionSolverMassRatio::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DEFAULT | hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEFAULT, (&hkpVehicleData_m_maxFrictionSolverMassRatio_Auto::defaultVal)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxFrictionSolverMassRatio"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxFrictionSolverMassRatio, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_wheelParams::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkArray< hkpVehicleData::WheelComponentParams > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "wheelParams"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_wheelParams, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hkpVehicleData::_Auto::isValid_m_wheelParams),))
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_numWheelsPerAxle::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT | hkReflect::Opt::VALIDATE),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkArray< hkReflect::Typedef::hkInt8_Tag > ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "numWheelsPerAxle"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_numWheelsPerAxle, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::VALIDATE, hkpVehicleData::_Auto::isValid_m_numWheelsPerAxle),))
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_chassisFrictionInertiaInvDiag::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkVector4_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "chassisFrictionInertiaInvDiag"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_chassisFrictionInertiaInvDiag, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::_Auto::m_alreadyInitialised::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkBool ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "alreadyInitialised"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_alreadyInitialised, hkpVehicleData)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData )),
};;

const hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*,18> hkpVehicleData::_Auto::Decls::decls = 
{
    { 18, 0, 18, 0 }, {
        reinterpret_cast<const hkReflect::Type*>(&m_gravity::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_numWheels::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_chassisOrientation::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_torqueRollFactor::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_torquePitchFactor::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_torqueYawFactor::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_extraTorqueFactor::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxVelocityForPositionalFriction::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_chassisUnitInertiaYaw::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_chassisUnitInertiaRoll::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_chassisUnitInertiaPitch::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_frictionEqualizer::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_normalClippingAngleCos::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxFrictionSolverMassRatio::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_wheelParams::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_numWheelsPerAxle::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_chassisFrictionInertiaInvDiag::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_alreadyInitialised::typeData),
 }};

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#if defined(HK_INCLUDE_VALIDATE_INLINES) || defined(HK_DETAIL_REFLECT_DEFINITIONS)
HK_REFLECT_VALIDATE_INLINE bool hkpVehicleData::reflectValidate() const { return hkpVehicleData::_Auto::isValid(*this); };
#endif
#if defined(HK_MEMORY_TRACKER_ENABLE) && defined(HK_DETAIL_REFLECT_DEFINITIONS)
hkReflect::Detail::TrackerRegNode hkpVehicleData_trackerRegNode( hkReflect::ReflectionOf< hkpVehicleData >::Holder::typeData, HK_TRACKER_GET_HANDLE_UNCHECKED( hkpVehicleData::_OldMacroHack ), false );
#endif

#ifdef HK_DETAIL_REFLECT_DEFINITIONS

////////////////////////////////////////////////////////////////////////////////
// CXXRecord: hkpVehicleData::WheelComponentParams
//

hkReflect::Detail::TypeRegNode hkpVehicleData_WheelComponentParams_typeRegNode( HK_REFLECT_GET_NON_CONST_TYPE( hkpVehicleData::WheelComponentParams ) );

hkReflect::Detail::TypeData hkReflect::ReflectionOf< hkpVehicleData::WheelComponentParams >::Holder::typeData =
{    
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN | hkReflect::Opt::DECLS),//optionals
    (hkUlong)0,//parent    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfRecord::Value),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::IMPL, &hkReflect::Detail::HavokRecordImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, "hkpVehicleData::WheelComponentParams"),    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::DEF_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_CONSTRUCTOR >::func),))    
    HK_EXCLUDE_FROM_DATA_REFLECTION((HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial< hkReflect::Opt::COPY_ASSIGNMENT >::func),))    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::INHERITANCE, 0),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(hkpVehicleData::WheelComponentParams),HK_ALIGN_OF(hkpVehicleData::WheelComponentParams),0)),    
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECLS, reinterpret_cast<const hkReflect::Detail::DeclsArray*>(&hkpVehicleData::WheelComponentParams::_Auto::Decls::decls)),    
};
const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_radius::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "radius"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_radius, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_mass::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "mass"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_mass, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_width::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "width"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_width, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_friction::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "friction"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_friction, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_viscosityFriction::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "viscosityFriction"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_viscosityFriction, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_maxFriction::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxFriction"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxFriction, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_slipAngle::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "slipAngle"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_slipAngle, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_forceFeedbackMultiplier::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "forceFeedbackMultiplier"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_forceFeedbackMultiplier, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_maxContactBodyAcceleration::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkReal_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "maxContactBodyAcceleration"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_maxContactBodyAcceleration, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::TypeData hkpVehicleData::WheelComponentParams::_Auto::m_axle::typeData = {
    HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_NAME | hkReflect::Opt::DECL_FORMAT | hkReflect::Opt::DECL_CONTEXT),//optionals
    (hkUlong)HK_REFLECT_GET_TYPE( hkReflect::Typedef::hkInt8_Tag ),//parent
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_NAME, "axle"),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD)<<16) | HK_ROFFSET_OF(m_axle, hkpVehicleData::WheelComponentParams)),
    HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_CONTEXT, HK_REFLECT_GET_TYPE( hkpVehicleData::WheelComponentParams )),
};;

const hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*,10> hkpVehicleData::WheelComponentParams::_Auto::Decls::decls = 
{
    { 10, 0, 10, 0 }, {
        reinterpret_cast<const hkReflect::Type*>(&m_radius::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_mass::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_width::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_friction::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_viscosityFriction::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxFriction::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_slipAngle::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_forceFeedbackMultiplier::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_maxContactBodyAcceleration::typeData),
        reinterpret_cast<const hkReflect::Type*>(&m_axle::typeData),
 }};

#endif // HK_DETAIL_REFLECT_DEFINITIONS

#if defined(HK_INCLUDE_VALIDATE_INLINES) || defined(HK_DETAIL_REFLECT_DEFINITIONS)
HK_REFLECT_VALIDATE_INLINE bool hkpVehicleData::WheelComponentParams::reflectValidate() const { return true; };
#endif


#if defined(HK_COMPILER_GCC)
#pragma GCC diagnostic pop
#endif

#if 0
//)exclude2";
#endif

/*
 * Havok SDK - Generated
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
