// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Dynamics/Phantom/hkpPhantomOverlapListener.h>

/// An hkpPhantomOverlapListener is used to ignore the chassis and other phantoms
/// when doing collision detection.
/// (This inherits from base object so that it can be serialized without
/// the listener interface declared as reflected.)
class HK_EXPORT_PHYSICS_2012 hkpRejectChassisListener : public hkReferencedObject, public hkpPhantomOverlapListener
{
    public:
        // +version(1)

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VEHICLE);
        HK_DECLARE_REFLECTION();

        hkpRejectChassisListener() { }

        virtual ~hkpRejectChassisListener()
        {
            if ( m_chassis != HK_NULL )
            {
                // remove reference?
                //m_chassis->removeReference();
            }
        }

        //
        // Methods
        //

        void collidableAddedCallback(const hkpCollidableAddedEvent& event);

        void collidableRemovedCallback(const hkpCollidableRemovedEvent& event);

        //
        // Members
        //
    public:

            /// The collidable of the owning vehicle's chassis which should be ignored.
        const hkpCollidable* m_chassis; //+nosave
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
