// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/VelocityDamper/hkpVehicleVelocityDamper.h>

/// An angular velocity damper which reduces a vehicle's ability to spin in the air,
/// making it more stable.
class HK_EXPORT_PHYSICS_2012 hkpVehicleDefaultVelocityDamper : public hkpVehicleVelocityDamper
{
    public:
        HK_DECLARE_CLASS(hkpVehicleDefaultVelocityDamper, Reflect, New, BypassCtor);

            /// Default constructor
        hkpVehicleDefaultVelocityDamper();

        //
        // Methods
        //

            /// This controller dampens the vehicle angular velocity.
        virtual void applyVelocityDamping(const hkReal deltaTime, hkpVehicleInstance& vehicle);

        //
        // Members
        //
    public:

            /// A damping of the chassis angular velocity in normal mode
        hkReal m_normalSpinDamping;

            /// A damping of the chassis angular velocity in collision mode.
        hkReal m_collisionSpinDamping;

            /// If the chassis angular velocity is higher than this value, the engine assumes
            /// collision.
        hkReal m_collisionThreshold;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
