// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Vehicle/hkpVehicle.h>

#include <Physics2012/Vehicle/hkpVehicleInstance.h>

#include <Physics2012/Vehicle/VelocityDamper/Default/hkpVehicleDefaultVelocityDamper.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>

hkpVehicleDefaultVelocityDamper::hkpVehicleDefaultVelocityDamper()
{
    m_normalSpinDamping = 0;
    m_collisionSpinDamping = 0;
    m_collisionThreshold = 1.0f;
}

// can't be const because of the changing of one of the members (unless you make that member mutable)
void hkpVehicleDefaultVelocityDamper::applyVelocityDamping(const hkReal deltaTime, hkpVehicleInstance& vehicle )
{
    hkpRigidBody*   chassis_motionstate = vehicle.getChassis();
    hkVector4 angularVel = chassis_motionstate->getAngularVelocity();
    const hkReal spinSqrd = angularVel.lengthSquared<3>().getReal();

    hkReal exp_time;
    if (spinSqrd > m_collisionThreshold * m_collisionThreshold)
    {
        exp_time = hkMath::max2( hkReal(0.0f), 1.0f - deltaTime * m_collisionSpinDamping );
    }
    else
    {
        exp_time = hkMath::max2( hkReal(0.0f), 1.0f - deltaTime * m_normalSpinDamping );
    }

    hkVector4 newAngVel; newAngVel.setMul( hkSimdReal::fromFloat(exp_time), angularVel);

    chassis_motionstate ->setAngularVelocity( newAngVel);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
