// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


class hkpVehicleInstance;
class hkpVehicleData;

/// A tyremark point is defined by two points (left and right and the strength of
/// the tyremark). Having two points instead of one allows for thickness in
/// tyremarks. The strength is a user value that can be used, for example, to
/// shade tyremarks depending on the amount of skidding
struct HK_EXPORT_PHYSICS_2012 hkpTyremarkPoint
{
    public:

        HK_DECLARE_REFLECTION();

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VEHICLE, hkpTyremarkPoint);

            /// Default constructor
        hkpTyremarkPoint();

        //
        // Methods
        //

            /// The strength of a tyremarkPoint is stored in the w-component
            /// of the vectors. The strength is in the range 0.0f to 255.0f.
        hkReal getTyremarkStrength() const;

        //
        // Members
        //
    public:

            /// The left position of the tyremark.
        hkVector4 m_pointLeft;

            /// The right position of the tyremark.
        hkVector4 m_pointRight;
};


/// hkpTyremarksWheel stores a list of tyremarks associated with a particular wheel.
/// This is a circular array, so old tyremarks eventually get replaced by new
/// tyremarks.
class HK_EXPORT_PHYSICS_2012 hkpTyremarksWheel : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VEHICLE);
        HK_DECLARE_REFLECTION();

            /// Default constructor
        hkpTyremarksWheel();

        virtual ~hkpTyremarksWheel() {}

        //
        // Methods
        //

            /// Sets the number of tyre mark points that can be stored.
        void setNumPoints(int num_points);

            /// Add a tyreMarkPoint to the array.
        void addTyremarkPoint( hkpTyremarkPoint& point);

            /// Returns the i-th stored tyremark point in the object.
        const hkpTyremarkPoint& getTyremarkPoint(int point) const;

        //
        // Members
        //
    public:

            /// Current position in the array of tyremarkPoints.
        int m_currentPosition;

            /// The number of points in the array
        int m_numPoints;

            /// Circular array of tyreMarkPoints.
        hkArray<struct hkpTyremarkPoint> m_tyremarkPoints;
};


/// hkpTyremarksInfo stores a list of hkpTyremarksWheel for a particular vehicle
class HK_EXPORT_PHYSICS_2012 hkpTyremarksInfo : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS(hkpTyremarksInfo, New, Reflect, BypassCtor);

        //
        // Methods
        //

            /// Updates Tyremark information
        virtual void updateTyremarksInfo(hkReal timestep, const hkpVehicleInstance* vehicle);

            /// Retrieves the Tyremark information in the form of a strip
        virtual void getWheelTyremarksStrips(const hkpVehicleInstance* vehicle, int wheel, hkVector4* strips_out) const;

            /// The constructor takes a hkpVehicleData object and the number of skidmark
            /// points to store.
        hkpTyremarksInfo(const hkpVehicleData& data, int num_points);

        virtual ~hkpTyremarksInfo()
        {
            for ( int sw_it = 0 ; sw_it < m_tyremarksWheel.getSize() ; sw_it++ )
            {
                m_tyremarksWheel[sw_it]->removeReference();
            }
        }

        //
        // Members
        //
    public:

            /// The minimum energy a tyremark should have. The actual strength of a point will
            /// be scaled to be between 0.0f and 255.0f.
        hkReal m_minTyremarkEnergy;

            /// The maximum energy a tyremark should have. The actual strength of a point will
            /// be scaled to be between 0.0f and 255.0f.
        hkReal m_maxTyremarkEnergy;

            /// There is a hkpTyremarksWheel for each wheel.
        hkArray<class hkpTyremarksWheel*> m_tyremarksWheel;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
