// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/Suspension/hkpVehicleSuspension.h>

/// The hkpVehicleDefaultSuspension class implements a default, spring-based, suspension
/// module for vehicles.
class HK_EXPORT_PHYSICS_2012 hkpVehicleDefaultSuspension : public hkpVehicleSuspension
{
    public:
        HK_DECLARE_CLASS(hkpVehicleDefaultSuspension, Reflect, New, BypassCtor);

        hkpVehicleDefaultSuspension() { }

        //
        // Methods
        //

            /// Calculates information about the effects of suspension on the vehicle.
        virtual void calcSuspension(const hkReal deltaTime, const hkpVehicleInstance* vehicle, const hkpVehicleWheelCollide::CollisionDetectionWheelOutput* cdInfo, hkReal* suspensionForceOut);

        //
        // Members
        //
    public:


            /// A struct containing all the wheel spring suspension parameters.
        struct WheelSpringSuspensionParameters
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VEHICLE, hkpVehicleDefaultSuspension::WheelSpringSuspensionParameters );
            HK_DECLARE_REFLECTION();

                /// The strength [N/m] of the suspension at each wheel.
            hkReal m_strength;

                /// The damping force [N/(m/sec)] of the suspension at each wheel.
            hkReal m_dampingCompression;

                /// The damping force [N/(m/sec)] of the suspension at each wheel.
            hkReal m_dampingRelaxation;
        };

            /// Suspension wheel parameters for each wheel.
        hkArray<struct WheelSpringSuspensionParameters> m_wheelSpringParams;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
