// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/DriverInput/hkpVehicleDriverInput.h>

class hkpVehicleInstance;


/// An abstract component for vehicle steering for both the main (chassis) and
/// individual wheel steering angles. The hkpVehicleSteering class is responsible
/// for calculating the main steering angle of the vehicle and the steering angle of
/// each wheel. A typical implementation will be likely to use the steering wheel
/// input value from the vehicle's hkpVehicleDriverInput and transform it into a
/// steering angle.
class HK_EXPORT_PHYSICS_2012 hkpVehicleSteering : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VEHICLE);
        HK_DECLARE_REFLECTION();

        /// Container for data output by the steering calculations.
        struct SteeringAnglesOutput
        {
            public:
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VEHICLE, hkpVehicleSteering::SteeringAnglesOutput );
                /// The angle the steering wheel has been turned.
            hkReal m_mainSteeringAngle;
            hkReal m_mainSteeringAngleAssumingNoReduction;

                /// The angle a wheel turns (if it can be steered).
            hkInplaceArray< hkReal, 32 > m_wheelsSteeringAngle;
        };

        //
        // Methods
        //

            /// Calculates information about the effects of steering on the vehicle.
        virtual void calcSteering(const hkReal deltaTime, const hkpVehicleInstance* vehicle, const hkpVehicleDriverInput::FilteredDriverInputOutput& filteredInfoOutput, SteeringAnglesOutput& steeringOutput ) = 0;

    protected:

        hkpVehicleSteering() {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
