// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/Steering/hkpVehicleSteering.h>

/// The hkpVehicleDefaultSteering class implements a hkpVehicleSteering that maps the
/// steering input from the hkpVehicleDriverInput to a main steering angle, using a
/// velocity-dependant mapping (for high velocities the steering is reduced). The
/// steering for each wheel is either 0.0f (no steering) or equals the main steering
/// angle, depending on a hkBool value specified for each wheel.
///
/// The main steering angle is calculated using the following formula:
///
/// angle = input * maxAngle;
///
/// as input goes from -1 to 1, angle goes from -maxAngle to maxAngle .
class HK_EXPORT_PHYSICS_2012 hkpVehicleDefaultSteering : public hkpVehicleSteering
{
    public:
        HK_DECLARE_CLASS(hkpVehicleDefaultSteering, Reflect, New, BypassCtor);

            /// Default constructor
        hkpVehicleDefaultSteering();

        //
        // Methods
        //

            /// Calculates information about the effects of steering on the vehicle.
        virtual void calcSteering(const hkReal deltaTime, const hkpVehicleInstance* vehicle, const hkpVehicleDriverInput::FilteredDriverInputOutput& filteredInfoOutput, SteeringAnglesOutput& steeringOutput );

            /// Calculates the main steering angle.
        virtual void calcMainSteeringAngle( const hkReal deltaTime, const hkpVehicleInstance* vehicle, const hkpVehicleDriverInput::FilteredDriverInputOutput& filteredInfoOutput, SteeringAnglesOutput& steeringOutput );

        //
        // Members
        //
    public:

            /// The maximum steering angle (valid for velocities less than
            /// m_maxSpeedFullSteeringAngle).
        hkReal m_maxSteeringAngle;

            /// The maximum speed the car still can use the m_maxSteeringAngle.
        hkReal m_maxSpeedFullSteeringAngle;

            /// For every wheel, should be true if the wheel is connected to steering.
        hkArray<hkBool> m_doesWheelSteer;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
