// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/Manager/MultithreadedVehicle/hkpVehicleJobs.h>

///
class HK_EXPORT_PHYSICS_2012 hkpVehicleSimulation : public hkReferencedObject
{
public:

    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_VEHICLE);
    HK_DECLARE_REFLECTION();

    // Input data for simulation
    struct SimulationInput
    {
        SimulationInput( const hkpVehicleAerodynamics::AerodynamicsDragOutput& aerodynamics,
            const hkArray<hkReal>& suspensions, const hkArray<hkReal>& linearForces )
            : aerodynamicsDragInfo(aerodynamics)
            , suspensionForceAtWheel(suspensions), totalLinearForceAtWheel(linearForces)
        {
        }

        const hkpVehicleAerodynamics::AerodynamicsDragOutput& aerodynamicsDragInfo;
        const hkArray<hkReal>& suspensionForceAtWheel;
        const hkArray<hkReal>& totalLinearForceAtWheel;
    };

    //
    // Methods
    //

    // Initialize simulation-specific data
    virtual void init( hkpVehicleInstance* instance ) = 0;

    // Support vehicle cloning
    virtual hkpVehicleSimulation* clone( hkpVehicleInstance* instance ) = 0;

    // Used by the per-wheel simulation to register/unregister world post-simulation listeners
    virtual void addToWorld( hkpWorld* world ) {}
    virtual void removeFromWorld() {}

    // Calculate and apply forces to the chassis and the rigid bodies the vehicle is riding on.
    virtual void simulateVehicle( hkpVehicleInstance* instance, const hkStepInfo& stepInfo, const SimulationInput& simulInput, hkpVehicleJobResults* vehicleJobResults ) = 0;

protected:

    hkpVehicleSimulation() {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
