// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Vehicle/Manager/hkpVehicleCastBatchingManager.h>
#include <Common/Base/Thread/Semaphore/hkSemaphoreBusyWait.h>
#include <Physics2012/Collide/Query/Multithreaded/RayCastQuery/hkpRayCastQueryJobs.h>

struct hkpShapeRayCastCommand;

/// Manages a set of vehicles whose wheelCollide objects are instances of hkpVehicleRayCastWheelCollide.
/// Ray casts can be batched and performed multithreaded.
class HK_EXPORT_PHYSICS_2012 hkpVehicleRayCastBatchingManager : public hkpVehicleCastBatchingManager
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VEHICLE );
        HK_DECLARE_REFLECTION();

            /// Constructor.
        hkpVehicleRayCastBatchingManager() { }

        //
        // Interface for asynchronous multithreading.
        //

        virtual int getBufferSize( int numJobs, hkArray< hkpVehicleInstance* >& activeVehicles );

        virtual int buildAndAddCastJobs( const hkpWorld* world, hkInt32 filterSize, int numJobs, hkJobQueue* jobQueue, hkSemaphoreBusyWait* semaphore, void* buffer, hkArray< hkpVehicleInstance* >& activeVehicles );

        virtual void stepVehiclesUsingCastResults( const hkStepInfo& updatedStepInfo, int numJobs, void* buffer, hkArray< hkpVehicleInstance* >& activeVehicles );

    public:
        //
        // Internal
        //

            /// The buffer is divided as follows:
        struct RaycastBatch
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpVehicleRayCastBatchingManager::RaycastBatch);
                /// A pointer to enough space for one command per wheel.
                /// This space is divided into chunks, with each chunk containing
                /// all the commands for the wheels of a single vehicle.
                /// The chunks are consecutive, so if some vehicles do not issue
                /// commands, there will be unused commands at the end.
            hkpShapeRayCastCommand* m_commandStorage;
                /// A pointer to enough space for one raycast output per wheel.
                /// The elements of this array correspond directly to the commands in
                /// m_commandStorage, and are arranged in the same way.
            hkpWorldRayCastOutput* m_outputStorage;
                /// A pointer to an array of the number of commands issued for each vehicle.
            hkUint8* m_index;
                /// The headers of the raycast jobs.
            hkpCollisionQueryJobHeader* m_jobHeaders;
        };

            /// Fills out a RaycastBatch structure with pointers into the provided buffer.
        void getRaycastBatchFromBuffer( void* raycastBuffer, int numJobs, RaycastBatch& raycastBatch, hkArray< hkpVehicleInstance* >& activeVehicles );
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
