// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/JobQueue/hkJobQueue.h>

/// Utils to allow vehicle jobs to be executed from a job queue
struct HK_EXPORT_PHYSICS_2012 hkpVehicleJobQueueUtils
{
    static hkJobQueue::JobPopFuncResult  HK_CALL popVehicleJob   ( hkJobQueue& queue,
                                    hkJobQueue::DynamicData* data,
                                    hkJobQueue::JobQueueEntry& jobIn,
                                    hkJobQueue::JobQueueEntry& jobOut  );

    static hkJobQueue::JobCreationStatus HK_CALL finishVehicleJob( hkJobQueue& queue,
                                    hkJobQueue::DynamicData* data,
                                    const hkJobQueue::JobQueueEntry& jobIn,
                                    hkJobQueue::JobQueueEntryInput& newJobCreated );


    static void HK_CALL registerWithJobQueue( hkJobQueue* jobQueue );
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
